/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.storage.logit.storage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.conf.Configuration;
import org.apache.ignite3.raft.jraft.conf.ConfigurationEntry;
import org.apache.ignite3.raft.jraft.conf.ConfigurationManager;
import org.apache.ignite3.raft.jraft.entity.EnumOutter;
import org.apache.ignite3.raft.jraft.entity.LogEntry;
import org.apache.ignite3.raft.jraft.entity.LogId;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryEncoder;
import org.apache.ignite3.raft.jraft.option.LogStorageOptions;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.storage.LogStorage;
import org.apache.ignite3.raft.jraft.storage.logit.option.StoreOptions;
import org.apache.ignite3.raft.jraft.storage.logit.storage.db.AbstractDB;
import org.apache.ignite3.raft.jraft.storage.logit.storage.db.ConfDB;
import org.apache.ignite3.raft.jraft.storage.logit.storage.db.IndexDB;
import org.apache.ignite3.raft.jraft.storage.logit.storage.db.SegmentLogDB;
import org.apache.ignite3.raft.jraft.storage.logit.storage.factory.LogStoreFactory;
import org.apache.ignite3.raft.jraft.storage.logit.storage.file.assit.FirstLogIndexCheckpoint;
import org.apache.ignite3.raft.jraft.storage.logit.storage.file.index.IndexFile;
import org.apache.ignite3.raft.jraft.storage.logit.storage.file.index.IndexType;
import org.apache.ignite3.raft.jraft.storage.logit.util.Pair;
import org.apache.ignite3.raft.jraft.util.OnlyForTest;
import org.apache.ignite3.raft.jraft.util.Requires;

public class LogitLogStorage
implements LogStorage {
    private static final IgniteLogger LOG = Loggers.forClass(LogitLogStorage.class);
    private static final String INDEX_STORE_PATH = "LogIndex";
    private static final String SEGMENT_STORE_PATH = "LogSegment";
    private static final String CONF_STORE_PATH = "LogConf";
    private static final String FIRST_INDEX_CHECKPOINT = "FirstLogIndexCheckpoint";
    private final FirstLogIndexCheckpoint firstLogIndexCheckpoint;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final StoreOptions storeOptions;
    private final RaftOptions raftOptions;
    private final String indexStorePath;
    private final String segmentStorePath;
    private final String confStorePath;
    private ConfigurationManager configurationManager;
    private LogEntryEncoder logEntryEncoder;
    private LogEntryDecoder logEntryDecoder;
    private SegmentLogDB segmentLogDB;
    private IndexDB indexDB;
    private ConfDB confDB;
    private LogStoreFactory logStoreFactory;
    private final ScheduledExecutorService checkpointExecutor;

    public LogitLogStorage(Path path, StoreOptions storeOptions, RaftOptions raftOptions, ScheduledExecutorService checkpointExecutor) {
        this.indexStorePath = path.resolve(INDEX_STORE_PATH).toString();
        this.segmentStorePath = path.resolve(SEGMENT_STORE_PATH).toString();
        this.confStorePath = path.resolve(CONF_STORE_PATH).toString();
        this.storeOptions = storeOptions;
        this.raftOptions = raftOptions;
        this.checkpointExecutor = checkpointExecutor;
        String checkPointPath = path.resolve(FIRST_INDEX_CHECKPOINT).toString();
        this.firstLogIndexCheckpoint = new FirstLogIndexCheckpoint(checkPointPath, raftOptions);
    }

    @Override
    public boolean init(LogStorageOptions opts) {
        Requires.requireNonNull(opts.getConfigurationManager(), "Null conf manager");
        Requires.requireNonNull(opts.getLogEntryCodecFactory(), "Null log entry codec factory");
        this.writeLock.lock();
        try {
            this.logEntryDecoder = opts.getLogEntryCodecFactory().decoder();
            this.logEntryEncoder = opts.getLogEntryCodecFactory().encoder();
            this.configurationManager = opts.getConfigurationManager();
            this.logStoreFactory = new LogStoreFactory(this.storeOptions, this.raftOptions);
            this.indexDB = new IndexDB(this.indexStorePath, this.checkpointExecutor);
            this.segmentLogDB = new SegmentLogDB(this.segmentStorePath, this.checkpointExecutor);
            this.confDB = new ConfDB(this.confStorePath, this.checkpointExecutor);
            if (!(this.indexDB.init(this.logStoreFactory) && this.segmentLogDB.init(this.logStoreFactory) && this.confDB.init(this.logStoreFactory))) {
                LOG.warn("Init dbs failed when startup logitLogStorage", new Object[0]);
                boolean bl = false;
                return bl;
            }
            this.firstLogIndexCheckpoint.load();
            boolean bl = this.recoverAndLoad();
            return bl;
        }
        catch (IOException e) {
            LOG.error("Error on load firstLogIndexCheckPoint", (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
        return false;
    }

    public boolean recoverAndLoad() {
        this.writeLock.lock();
        try {
            this.indexDB.recover();
            this.segmentLogDB.recover();
            this.confDB.recover();
            if (!this.checkConsistencyAndAlignLog()) {
                LOG.warn("Check the consistency and align log failed", new Object[0]);
                boolean bl = false;
                return bl;
            }
            this.loadConfiguration();
            if (!this.firstLogIndexCheckpoint.isInit()) {
                this.saveFirstLogIndex(this.indexDB.getFirstLogIndex());
            }
            LOG.info("Recover dbs and start timingServer success, last recover index:{}", this.indexDB.getLastLogIndex());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Error on recover db", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean checkConsistencyAndAlignLog() {
        long lastIndex = this.indexDB.getLastLogIndex();
        long lastSegmentIndex = this.segmentLogDB.getLastLogIndex();
        long lastConfIndex = this.confDB.getLastLogIndex();
        if (lastIndex == lastSegmentIndex || lastIndex == lastConfIndex) {
            return true;
        }
        long maxLogIndex = Math.max(lastSegmentIndex, lastConfIndex);
        if (lastIndex > maxLogIndex) {
            return this.indexDB.truncateSuffix(maxLogIndex, 0);
        }
        Pair<IndexFile.IndexEntry, IndexFile.IndexEntry> lastIndexPair = this.indexDB.lookupLastLogIndexAndPosFromTail();
        IndexFile.IndexEntry lastSegmentIndexInfo = lastIndexPair.getFirst();
        IndexFile.IndexEntry lastConfIndexInfo = lastIndexPair.getSecond();
        if (lastSegmentIndexInfo == null) {
            lastSegmentIndexInfo = new IndexFile.IndexEntry(this.segmentLogDB.getFirstLogIndex(), 26, IndexType.IndexSegment.getType());
        }
        if (lastConfIndexInfo == null) {
            lastConfIndexInfo = new IndexFile.IndexEntry(this.confDB.getFirstLogIndex(), 26, IndexType.IndexConf.getType());
        }
        AbstractDB.LogEntryIterator segmentLogIterator = this.segmentLogDB.iterator(this.logEntryDecoder, lastSegmentIndexInfo.getLogIndex(), lastSegmentIndexInfo.getPosition());
        AbstractDB.LogEntryIterator confLogIterator = this.confDB.iterator(this.logEntryDecoder, lastConfIndexInfo.getLogIndex(), lastConfIndexInfo.getPosition());
        List<IndexFile.IndexEntry> indexArray = this.generateOrderedIndexArrayByMergingLogIterator(segmentLogIterator, confLogIterator);
        long maxFlushPosition = this.indexDB.appendBatchIndexAsync(indexArray);
        return this.indexDB.waitForFlush(maxFlushPosition, this.storeOptions.getMaxFlushTimes());
    }

    public List<IndexFile.IndexEntry> generateOrderedIndexArrayByMergingLogIterator(AbstractDB.LogEntryIterator segmentLogIterator, AbstractDB.LogEntryIterator confLogIterator) {
        LogEntry segmentEntry = null;
        LogEntry confEntry = null;
        int segmentPosition = -1;
        int confPosition = -1;
        ArrayList<IndexFile.IndexEntry> indexEntries = new ArrayList<IndexFile.IndexEntry>();
        while (true) {
            if (segmentEntry == null && segmentLogIterator != null && segmentLogIterator.hasNext()) {
                segmentEntry = segmentLogIterator.next();
                segmentPosition = segmentLogIterator.getReadPosition();
            }
            if (confEntry == null && confLogIterator != null && confLogIterator.hasNext()) {
                confEntry = confLogIterator.next();
                confPosition = confLogIterator.getReadPosition();
            }
            if (segmentEntry == null && confEntry == null) break;
            if (segmentEntry != null && confEntry != null) {
                if (segmentEntry.getId().getIndex() < confEntry.getId().getIndex()) {
                    indexEntries.add(new IndexFile.IndexEntry(segmentEntry.getId().getIndex(), segmentPosition, IndexType.IndexSegment.getType()));
                    segmentEntry = null;
                    continue;
                }
                indexEntries.add(new IndexFile.IndexEntry(confEntry.getId().getIndex(), confPosition, IndexType.IndexConf.getType()));
                confEntry = null;
                continue;
            }
            indexEntries.add(segmentEntry != null ? new IndexFile.IndexEntry(segmentEntry.getId().getIndex(), segmentPosition, IndexType.IndexSegment.getType()) : new IndexFile.IndexEntry(confEntry.getId().getIndex(), confPosition, IndexType.IndexConf.getType()));
            confEntry = null;
            segmentEntry = null;
        }
        return indexEntries;
    }

    private boolean saveFirstLogIndex(long logIndex) {
        try {
            this.firstLogIndexCheckpoint.setFirstLogIndex(logIndex);
            return this.firstLogIndexCheckpoint.save();
        }
        catch (IOException e) {
            LOG.error("Error when save first log index", (Throwable)e);
            return false;
        }
    }

    public void loadConfiguration() {
        LogEntry entry;
        AbstractDB.LogEntryIterator confIterator = this.confDB.iterator(this.logEntryDecoder);
        while ((entry = confIterator.next()) != null) {
            if (entry.getType() != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) continue;
            ConfigurationEntry confEntry = new ConfigurationEntry();
            confEntry.setId(new LogId(entry.getId().getIndex(), entry.getId().getTerm()));
            confEntry.setConf(new Configuration(entry.getPeers(), entry.getLearners()));
            if (entry.getOldPeers() != null) {
                confEntry.setOldConf(new Configuration(entry.getOldPeers(), entry.getOldLearners()));
            }
            if (this.configurationManager == null) continue;
            this.configurationManager.add(confEntry);
        }
    }

    @Override
    public long getFirstLogIndex() {
        this.readLock.lock();
        try {
            if (this.firstLogIndexCheckpoint.firstLogIndex >= 0L) {
                long l = this.firstLogIndexCheckpoint.firstLogIndex;
                return l;
            }
            if (this.indexDB.getFirstLogIndex() >= 0L) {
                long l = this.indexDB.getFirstLogIndex();
                return l;
            }
            long l = 1L;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getLastLogIndex() {
        this.readLock.lock();
        try {
            if (this.indexDB.getLastLogIndex() >= 0L) {
                long l = this.indexDB.getLastLogIndex();
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntry getEntry(long index) {
        this.readLock.lock();
        try {
            byte[] logBytes;
            if (index < this.getFirstLogIndex() || index > this.getLastLogIndex()) {
                LogEntry logEntry = null;
                return logEntry;
            }
            IndexFile.IndexEntry indexEntry = this.indexDB.lookupIndex(index);
            int phyPosition = indexEntry.getPosition();
            byte logType = indexEntry.getLogType();
            if (phyPosition != -1 && (logBytes = logType == IndexType.IndexSegment.getType() ? this.segmentLogDB.lookupLog(index, phyPosition) : this.confDB.lookupLog(index, phyPosition)) != null) {
                LogEntry logEntry = this.logEntryDecoder.decode(logBytes);
                return logEntry;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    @Override
    public long getTerm(long index) {
        LogEntry entry = this.getEntry(index);
        if (entry != null) {
            return entry.getId().getTerm();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean appendEntry(LogEntry entry) {
        this.readLock.lock();
        try {
            long logIndex = entry.getId().getIndex();
            if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                boolean bl = this.doAppendEntry(logIndex, entry, this.confDB, IndexType.IndexConf, true);
                return bl;
            }
            boolean bl = this.doAppendEntry(logIndex, entry, this.segmentLogDB, IndexType.IndexSegment, true);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int appendEntries(List<LogEntry> entries) {
        this.readLock.lock();
        try {
            int i;
            int appendCount = 0;
            int size = entries.size();
            int lastLogIndex = -1;
            int lastConfIndex = -1;
            for (i = entries.size() - 1; i >= 0; --i) {
                boolean isConfEntry;
                LogEntry entry = entries.get(i);
                boolean bl = isConfEntry = entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION;
                if (isConfEntry && lastConfIndex == -1) {
                    lastConfIndex = i;
                } else if (!isConfEntry && lastLogIndex == -1) {
                    lastLogIndex = i;
                }
                if (lastConfIndex >= 0 && lastLogIndex >= 0) break;
            }
            for (i = 0; i < size; ++i) {
                boolean isWaitingFlush = i == lastLogIndex || i == lastConfIndex;
                LogEntry entry = entries.get(i);
                long logIndex = entry.getId().getIndex();
                if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                    if (!this.doAppendEntry(logIndex, entry, this.confDB, IndexType.IndexConf, isWaitingFlush)) continue;
                    ++appendCount;
                    continue;
                }
                if (!this.doAppendEntry(logIndex, entry, this.segmentLogDB, IndexType.IndexSegment, isWaitingFlush)) continue;
                ++appendCount;
            }
            int n = appendCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doAppendEntry(long logIndex, LogEntry entry, AbstractDB logDB, IndexType indexType, boolean isWaitingFlush) {
        this.readLock.lock();
        try {
            if (logDB == null || this.indexDB == null) {
                boolean bl = false;
                return bl;
            }
            Pair<Integer, Long> logPair = logDB.appendLogAsync(logIndex, this.logEntryEncoder, entry);
            if (logPair.getFirst() < 0 || logPair.getSecond() < 0L) {
                boolean bl = false;
                return bl;
            }
            Pair<Integer, Long> indexPair = this.indexDB.appendIndexAsync(logIndex, logPair.getFirst(), indexType);
            if (indexPair.getFirst() < 0 || indexPair.getSecond() < 0L) {
                boolean bl = false;
                return bl;
            }
            if (!this.firstLogIndexCheckpoint.isInit()) {
                this.saveFirstLogIndex(logIndex);
            }
            if (isWaitingFlush) {
                boolean bl = this.waitForFlush(logDB, logPair.getSecond(), indexPair.getSecond());
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean waitForFlush(AbstractDB logDB, long exceptedLogPosition, long exceptedIndexPosition) {
        int maxFlushTimes = this.storeOptions.getMaxFlushTimes();
        if (!logDB.waitForFlush(exceptedLogPosition, maxFlushTimes)) {
            return false;
        }
        return this.indexDB.waitForFlush(exceptedIndexPosition, maxFlushTimes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncatePrefix(long firstIndexKept) {
        this.readLock.lock();
        try {
            boolean ret = this.saveFirstLogIndex(firstIndexKept);
            if (ret) {
                this.indexDB.truncatePrefix(firstIndexKept);
                this.segmentLogDB.truncatePrefix(firstIndexKept);
                this.confDB.truncatePrefix(firstIndexKept);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean truncateSuffix(long lastIndexKept) {
        Pair<Integer, Integer> posPair = this.indexDB.lookupFirstLogPosFromLogIndex(lastIndexKept + 1L);
        int SegmentTruncatePos = posPair.getFirst();
        int ConfLogTruncatePos = posPair.getSecond();
        int lastIndexKeptPos = this.indexDB.lookupIndex(lastIndexKept).getPosition();
        if (lastIndexKeptPos != -1) {
            this.indexDB.truncateSuffix(lastIndexKept, 0);
            this.segmentLogDB.truncateSuffix(lastIndexKept, SegmentTruncatePos);
            this.confDB.truncateSuffix(lastIndexKept, ConfLogTruncatePos);
            return this.indexDB.getLastLogIndex() == lastIndexKept;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(long nextLogIndex) {
        this.writeLock.lock();
        try {
            LogEntry entry = this.getEntry(nextLogIndex);
            this.indexDB.reset(nextLogIndex);
            this.segmentLogDB.reset(nextLogIndex);
            this.confDB.reset(nextLogIndex);
            if (entry == null) {
                entry = new LogEntry();
                entry.setType(EnumOutter.EntryType.ENTRY_TYPE_NO_OP);
                entry.setId(new LogId(nextLogIndex, 0L));
            }
            this.saveFirstLogIndex(-1L);
            boolean bl = this.appendEntry(entry);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.writeLock.lock();
        try {
            this.indexDB.shutdown();
            this.segmentLogDB.shutdown();
            this.confDB.shutdown();
        }
        catch (Exception e) {
            LOG.error("Error on shutdown dbs", (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @OnlyForTest
    public IndexDB getIndexDB() {
        return this.indexDB;
    }

    @OnlyForTest
    public ConfDB getConfDB() {
        return this.confDB;
    }

    @OnlyForTest
    public SegmentLogDB getSegmentLogDB() {
        return this.segmentLogDB;
    }
}

