/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.sink.alertmanager;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.iotdb.db.engine.trigger.sink.alertmanager.AlertManagerConfiguration;
import org.apache.iotdb.db.engine.trigger.sink.alertmanager.AlertManagerEvent;
import org.apache.iotdb.db.engine.trigger.sink.api.Handler;
import org.apache.iotdb.db.engine.trigger.sink.exception.SinkException;

public class AlertManagerHandler
implements Handler<AlertManagerConfiguration, AlertManagerEvent> {
    private static CloseableHttpClient client;
    private static int referenceCount;
    private HttpPost request;

    private static synchronized void closeClient() throws IOException {
        if (--referenceCount == 0) {
            client.close();
        }
    }

    private static synchronized void openClient() {
        if (referenceCount++ == 0) {
            client = HttpClients.createDefault();
        }
    }

    @Override
    public void close() throws IOException {
        AlertManagerHandler.closeClient();
    }

    @Override
    public void open(AlertManagerConfiguration configuration) {
        if (this.request == null) {
            this.request = new HttpPost(configuration.getEndpoint());
            this.request.setHeader("Accept", "application/json");
            this.request.setHeader("Content-type", "application/json");
        }
        AlertManagerHandler.openClient();
    }

    @Override
    public void onEvent(AlertManagerEvent event) throws SinkException {
        try {
            this.request.setEntity((HttpEntity)new StringEntity("[" + event.toJsonString() + "]"));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)this.request);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new SinkException(response.getStatusLine().toString());
                }
            }
        }
        catch (Exception e) {
            throw new SinkException(e.getMessage());
        }
    }
}

