/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.path;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementPath
extends PartialPath {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementPath.class);
    private IMeasurementSchema measurementSchema;
    private boolean isUnderAlignedEntity = false;
    private String measurementAlias = "";

    public MeasurementPath() {
    }

    public MeasurementPath(String measurementPath) throws IllegalPathException {
        super(measurementPath);
    }

    public MeasurementPath(String measurementPath, TSDataType type) throws IllegalPathException {
        super(measurementPath);
        this.measurementSchema = new MeasurementSchema(this.getMeasurement(), type);
    }

    public MeasurementPath(PartialPath measurementPath, IMeasurementSchema measurementSchema) {
        super(measurementPath.getNodes());
        this.measurementSchema = measurementSchema;
    }

    public MeasurementPath(String device, String measurement, IMeasurementSchema measurementSchema) throws IllegalPathException {
        super(device, measurement);
        this.measurementSchema = measurementSchema;
    }

    @Override
    public IMeasurementSchema getMeasurementSchema() {
        return this.measurementSchema;
    }

    @Override
    public TSDataType getSeriesType() {
        return this.getMeasurementSchema().getType();
    }

    public byte getSeriesTypeInByte() {
        return this.getMeasurementSchema().getTypeInByte();
    }

    public void setMeasurementSchema(IMeasurementSchema measurementSchema) {
        this.measurementSchema = measurementSchema;
    }

    @Override
    public String getMeasurementAlias() {
        return this.measurementAlias;
    }

    @Override
    public void setMeasurementAlias(String measurementAlias) {
        if (measurementAlias != null) {
            this.measurementAlias = measurementAlias;
        }
    }

    @Override
    public boolean isMeasurementAliasExists() {
        return this.measurementAlias != null && !this.measurementAlias.isEmpty();
    }

    @Override
    public String getFullPathWithAlias() {
        return this.getDevice() + '.' + this.measurementAlias;
    }

    public boolean isUnderAlignedEntity() {
        return this.isUnderAlignedEntity;
    }

    public void setUnderAlignedEntity(boolean underAlignedEntity) {
        this.isUnderAlignedEntity = underAlignedEntity;
    }

    @Override
    public PartialPath copy() {
        MeasurementPath result = new MeasurementPath();
        result.nodes = this.nodes;
        result.fullPath = this.fullPath;
        result.device = this.device;
        result.measurementAlias = this.measurementAlias;
        result.measurementSchema = this.measurementSchema;
        result.isUnderAlignedEntity = this.isUnderAlignedEntity;
        return result;
    }

    public PartialPath transformToExactPath() {
        return this.isUnderAlignedEntity ? new AlignedPath(this) : this;
    }

    @Override
    public LastPointReader createLastPointReader(TSDataType dataType, Set<String> deviceMeasurements, QueryContext context, QueryDataSource dataSource, long queryTime, Filter timeFilter) {
        return new LastPointReader(this, dataType, deviceMeasurements, context, dataSource, queryTime, timeFilter);
    }

    @Override
    public SeriesReader createSeriesReader(Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, Filter timeFilter, Filter valueFilter, TsFileFilter fileFilter, boolean ascending) {
        return new SeriesReader((PartialPath)this, allSensors, dataType, context, dataSource, timeFilter, valueFilter, fileFilter, ascending);
    }

    @Override
    public SeriesReader createSeriesReader(Set<String> allSensors, TSDataType dataType, QueryContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, Filter timeFilter, Filter valueFilter, boolean ascending) {
        allSensors.add(this.getMeasurement());
        return new SeriesReader((PartialPath)this, allSensors, dataType, context, seqFileResource, unseqFileResource, timeFilter, valueFilter, ascending);
    }

    @Override
    public TsFileResource createTsFileResource(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList, TsFileResource originTsFileResource) throws IOException {
        TsFileResource tsFileResource = new TsFileResource(this, readOnlyMemChunk, chunkMetadataList, originTsFileResource);
        tsFileResource.setTimeSeriesMetadata(this, this.generateTimeSeriesMetadata(readOnlyMemChunk, chunkMetadataList));
        return tsFileResource;
    }

    @Override
    public ITimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList) throws IOException {
        TimeseriesMetadata timeSeriesMetadata = new TimeseriesMetadata();
        timeSeriesMetadata.setMeasurementId(this.measurementSchema.getMeasurementId());
        timeSeriesMetadata.setTSDataType(this.measurementSchema.getType());
        timeSeriesMetadata.setOffsetOfChunkMetaDataList(-1L);
        timeSeriesMetadata.setDataSizeOfChunkMetaDataList(-1);
        Statistics seriesStatistics = Statistics.getStatsByType((TSDataType)timeSeriesMetadata.getTSDataType());
        for (IChunkMetadata chunkMetadata : chunkMetadataList) {
            seriesStatistics.mergeStatistics(chunkMetadata.getStatistics());
        }
        for (ReadOnlyMemChunk memChunk : readOnlyMemChunk) {
            if (memChunk.isEmpty()) continue;
            seriesStatistics.mergeStatistics(memChunk.getChunkMetaData().getStatistics());
        }
        timeSeriesMetadata.setStatistics(seriesStatistics);
        return timeSeriesMetadata;
    }

    @Override
    public ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) throws QueryProcessException, IOException {
        IDeviceID deviceID;
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = memTable.getMemTableMap();
        if (!memTableMap.containsKey(deviceID = DeviceIDFactory.getInstance().getDeviceID(this.getDevicePath())) || !memTableMap.get(deviceID).contains(this.getMeasurement())) {
            return null;
        }
        IWritableMemChunk memChunk = memTableMap.get(deviceID).getMemChunkMap().get(this.getMeasurement());
        TVList chunkCopy = memChunk.getSortedTvListForQuery();
        int curSize = chunkCopy.rowCount();
        List<TimeRange> deletionList = null;
        if (modsToMemtable != null) {
            deletionList = this.constructDeletionList(memTable, modsToMemtable, timeLowerBound);
        }
        return new ReadOnlyMemChunk(this.getMeasurement(), this.measurementSchema.getType(), this.measurementSchema.getEncodingType(), chunkCopy, this.measurementSchema.getProps(), curSize, deletionList);
    }

    private List<TimeRange> constructDeletionList(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) {
        ArrayList<TimeRange> deletionList = new ArrayList<TimeRange>();
        deletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
        for (Modification modification : this.getModificationsForMemtable(memTable, modsToMemtable)) {
            Deletion deletion;
            if (!(modification instanceof Deletion) || !(deletion = (Deletion)modification).getPath().matchFullPath(this) || deletion.getEndTime() <= timeLowerBound) continue;
            long lowerBound = Math.max(deletion.getStartTime(), timeLowerBound);
            deletionList.add(new TimeRange(lowerBound, deletion.getEndTime()));
        }
        return TimeRange.sortAndMerge(deletionList);
    }

    @Override
    public MeasurementPath clone() {
        MeasurementPath newMeasurementPath = null;
        try {
            newMeasurementPath = new MeasurementPath(this.getDevice(), this.getMeasurement(), this.getMeasurementSchema());
            newMeasurementPath.setUnderAlignedEntity(this.isUnderAlignedEntity);
        }
        catch (IllegalPathException e) {
            logger.warn("path is illegal: {}", (Object)this.getFullPath(), (Object)e);
        }
        return newMeasurementPath;
    }

    @Override
    public List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter writer, TsFileResource tsFileResource, QueryContext context) {
        ModificationFile modificationFile = tsFileResource.getModFile();
        List<Modification> modifications = context.getPathModifications(modificationFile, this);
        ArrayList<IChunkMetadata> chunkMetadataList = new ArrayList<IChunkMetadata>(writer.getVisibleMetadataList(this.getDevice(), this.getMeasurement(), this.getSeriesType()));
        QueryUtils.modifyChunkMetaData(chunkMetadataList, modifications);
        chunkMetadataList.removeIf(context::chunkNotSatisfy);
        return chunkMetadataList;
    }
}

