/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.query.expression.ResultColumn;
import org.apache.iotdb.db.service.StaticResps;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.thrift.TException;

public class LastQueryPlan
extends RawDataQueryPlan {
    public LastQueryPlan() {
        this.setOperatorType(Operator.OperatorType.LAST);
    }

    @Override
    public void deduplicate(PhysicalGenerator physicalGenerator) throws MetadataException {
        ArrayList<ResultColumn> deduplicatedResultColumns = new ArrayList<ResultColumn>();
        HashSet<String> columnForReaderSet = new HashSet<String>();
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            String column = ((ResultColumn)this.resultColumns.get(i)).getResultColumnName();
            if (columnForReaderSet.contains(column)) continue;
            this.addDeduplicatedPaths((PartialPath)this.paths.get(i));
            deduplicatedResultColumns.add((ResultColumn)this.resultColumns.get(i));
            columnForReaderSet.add(column);
        }
        this.setResultColumns(deduplicatedResultColumns);
    }

    @Override
    public TSExecuteStatementResp getTSExecuteStatementResp(boolean isJdbcQuery) {
        return StaticResps.LAST_RESP.deepCopy();
    }

    @Override
    public List<TSDataType> getWideQueryHeaders(List<String> respColumns, List<String> respSgColumns, boolean isJdbcQuery, BitSet aliasList) throws TException {
        throw new TException("unsupported query type: " + (Object)((Object)this.getOperatorType()));
    }

    @Override
    public void setExpression(IExpression expression) throws QueryProcessException {
        if (!this.isValidExpression(expression)) {
            throw new QueryProcessException("Only '>' and '>=' are supported in LAST query");
        }
        super.setExpression(expression);
    }

    private boolean isValidExpression(IExpression expression) {
        if (expression instanceof GlobalTimeExpression) {
            Filter filter = ((GlobalTimeExpression)expression).getFilter();
            return filter instanceof TimeFilter.TimeGtEq || filter instanceof TimeFilter.TimeGt;
        }
        return false;
    }
}

