/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog;

import java.io.IOException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.flush.FlushListener;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;

public class WALFlushListener
implements FlushListener {
    private TsFileProcessor processor;

    public WALFlushListener(TsFileProcessor processor) {
        this.processor = processor;
    }

    @Override
    public void onFlushStart(IMemTable memTable) throws IOException {
        if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
            this.processor.getLogNode().notifyStartFlush();
        }
    }

    @Override
    public void onFlushEnd(IMemTable memTable) {
        if (!memTable.isSignalMemTable() && IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
            this.processor.getLogNode().notifyEndFlush();
        }
    }
}

