/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.cross.AbstractCrossSpaceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.cross.CrossSpaceCompactionTaskFactory;
import org.apache.iotdb.db.engine.compaction.inner.AbstractInnerSpaceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.inner.InnerSpaceCompactionTaskFactory;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;

public class CompactionScheduler {
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public static void scheduleCompaction(TsFileManager tsFileManager, long timePartition) {
        if (!tsFileManager.isAllowCompaction()) {
            return;
        }
        CompactionScheduler.tryToSubmitCrossSpaceCompactionTask(tsFileManager.getStorageGroupName(), tsFileManager.getVirtualStorageGroup(), tsFileManager.getStorageGroupDir(), timePartition, tsFileManager, new CrossSpaceCompactionTaskFactory());
        CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager.getStorageGroupName(), tsFileManager.getVirtualStorageGroup(), timePartition, tsFileManager, true, new InnerSpaceCompactionTaskFactory());
        CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager.getStorageGroupName(), tsFileManager.getVirtualStorageGroup(), timePartition, tsFileManager, false, new InnerSpaceCompactionTaskFactory());
    }

    public static void tryToSubmitInnerSpaceCompactionTask(String logicalStorageGroupName, String virtualStorageGroupName, long timePartition, TsFileManager tsFileManager, boolean sequence, InnerSpaceCompactionTaskFactory taskFactory) {
        if (!config.isEnableSeqSpaceCompaction() && sequence || !config.isEnableUnseqSpaceCompaction() && !sequence) {
            return;
        }
        AbstractInnerSpaceCompactionSelector innerSpaceCompactionSelector = config.getInnerCompactionStrategy().getCompactionSelector(logicalStorageGroupName, virtualStorageGroupName, timePartition, tsFileManager, sequence, taskFactory);
        innerSpaceCompactionSelector.selectAndSubmit();
    }

    private static void tryToSubmitCrossSpaceCompactionTask(String logicalStorageGroupName, String virtualStorageGroupName, String storageGroupDir, long timePartition, TsFileManager tsFileManager, CrossSpaceCompactionTaskFactory taskFactory) {
        if (!config.isEnableCrossSpaceCompaction()) {
            return;
        }
        AbstractCrossSpaceCompactionSelector crossSpaceCompactionSelector = config.getCrossCompactionStrategy().getCompactionSelector(logicalStorageGroupName, virtualStorageGroupName, storageGroupDir, timePartition, tsFileManager, taskFactory);
        crossSpaceCompactionSelector.selectAndSubmit();
    }
}

