/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.basic;

import org.apache.iotdb.cluster.coordinator.Coordinator;
import org.apache.iotdb.cluster.query.ClusterPlanExecutor;
import org.apache.iotdb.cluster.query.RemoteQueryContext;
import org.apache.iotdb.cluster.query.manage.ClusterSessionManager;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.SetSystemModePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterServiceProvider
extends ServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(ClusterServiceProvider.class);
    private final Coordinator coordinator;

    public ClusterServiceProvider(Coordinator coordinator, MetaGroupMember metaGroupMember) throws QueryProcessException {
        super((PlanExecutor)new ClusterPlanExecutor(metaGroupMember));
        this.coordinator = coordinator;
    }

    public TSStatus executeNonQueryPlan(PhysicalPlan plan) {
        try {
            plan.checkIntegrity();
            if (!(plan instanceof SetSystemModePlan) && !(plan instanceof FlushPlan) && IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.READ_ONLY_SYSTEM_ERROR, (String)"Database is read-only, and does not accept non-query operation now");
            }
        }
        catch (QueryProcessException e) {
            logger.warn("Illegal plan detected\uff1a {}", (Object)plan);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
        return this.coordinator.executeNonQueryPlan(plan);
    }

    public QueryContext genQueryContext(long queryId, boolean debug, long startTime, String statement, long timeout) {
        RemoteQueryContext context = new RemoteQueryContext(queryId, debug, startTime, statement, timeout);
        ClusterSessionManager.getInstance().putContext(queryId, context);
        return context;
    }

    public boolean executeNonQuery(PhysicalPlan plan) {
        TSStatus tsStatus = this.executeNonQueryPlan(plan);
        return tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
    }
}

