/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.user;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.auth.user.IUserAccessor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileUserAccessor
implements IUserAccessor {
    private static final String TEMP_SUFFIX = ".temp";
    private static final String STRING_ENCODING = "utf-8";
    private static final Logger logger = LoggerFactory.getLogger(LocalFileUserAccessor.class);
    private String userDirPath;
    private ThreadLocal<ByteBuffer> encodingBufferLocal = new ThreadLocal();
    private ThreadLocal<byte[]> strBufferLocal = new ThreadLocal();

    public LocalFileUserAccessor(String userDirPath) {
        this.userDirPath = userDirPath;
    }

    @Override
    public User loadUser(String username) throws IOException {
        File userProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ".profile");
        if (!userProfile.exists() || !userProfile.isFile()) {
            File newProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ".profile" + TEMP_SUFFIX);
            if (newProfile.exists() && newProfile.isFile()) {
                if (!newProfile.renameTo(userProfile)) {
                    logger.error("New profile renaming not succeed.");
                }
                userProfile = newProfile;
            } else {
                return null;
            }
        }
        FileInputStream inputStream = new FileInputStream(userProfile);
        try {
            User user;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            try {
                User user2 = new User();
                user2.setName(IOUtils.readString(dataInputStream, STRING_ENCODING, this.strBufferLocal));
                user2.setPassword(IOUtils.readString(dataInputStream, STRING_ENCODING, this.strBufferLocal));
                int privilegeNum = dataInputStream.readInt();
                ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
                for (int i = 0; i < privilegeNum; ++i) {
                    pathPrivilegeList.add(IOUtils.readPathPrivilege(dataInputStream, STRING_ENCODING, this.strBufferLocal));
                }
                user2.setPrivilegeList(pathPrivilegeList);
                int roleNum = dataInputStream.readInt();
                ArrayList<String> roleList = new ArrayList<String>();
                for (int i = 0; i < roleNum; ++i) {
                    String userName = IOUtils.readString(dataInputStream, STRING_ENCODING, this.strBufferLocal);
                    roleList.add(userName);
                }
                user2.setRoleList(roleList);
                long userProfileLength = userProfile.length();
                try {
                    user2.setUseWaterMark(dataInputStream.readInt() != 0);
                }
                catch (EOFException e1) {
                    user2.setUseWaterMark(false);
                    try (RandomAccessFile file = new RandomAccessFile(userProfile, "rw");){
                        file.seek(userProfileLength);
                        file.writeInt(0);
                    }
                }
                user = user2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dataInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            dataInputStream.close();
            return user;
        }
        finally {
            this.strBufferLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUser(User user) throws IOException {
        File userProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + user.getName() + ".profile" + TEMP_SUFFIX);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(userProfile));){
            try {
                IOUtils.writeString(outputStream, user.getName(), STRING_ENCODING, this.encodingBufferLocal);
                IOUtils.writeString(outputStream, user.getPassword(), STRING_ENCODING, this.encodingBufferLocal);
                user.getPrivilegeList().sort(PathPrivilege.REFERENCE_DESCENT_SORTER);
                int privilegeNum = user.getPrivilegeList().size();
                IOUtils.writeInt(outputStream, privilegeNum, this.encodingBufferLocal);
                for (int i = 0; i < privilegeNum; ++i) {
                    PathPrivilege pathPrivilege = user.getPrivilegeList().get(i);
                    IOUtils.writePathPrivilege(outputStream, pathPrivilege, STRING_ENCODING, this.encodingBufferLocal);
                }
                int userNum = user.getRoleList().size();
                IOUtils.writeInt(outputStream, userNum, this.encodingBufferLocal);
                for (int i = 0; i < userNum; ++i) {
                    IOUtils.writeString(outputStream, user.getRoleList().get(i), STRING_ENCODING, this.encodingBufferLocal);
                }
                IOUtils.writeInt(outputStream, user.isUseWaterMark() ? 1 : 0, this.encodingBufferLocal);
                outputStream.flush();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            this.encodingBufferLocal.remove();
        }
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + user.getName() + ".profile");
        IOUtils.replaceFile(userProfile, oldFile);
    }

    @Override
    public boolean deleteUser(String username) throws IOException {
        File userProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ".profile");
        File backFile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ".profile" + TEMP_SUFFIX);
        if (!userProfile.exists() && !backFile.exists()) {
            return false;
        }
        if (userProfile.exists() && !userProfile.delete() || backFile.exists() && !backFile.delete()) {
            throw new IOException(String.format("Cannot delete user file of %s", username));
        }
        return true;
    }

    @Override
    public List<String> listAllUsers() {
        File userDir = SystemFileFactory.INSTANCE.getFile(this.userDirPath);
        String[] names = userDir.list((dir, name) -> name.endsWith(".profile") || name.endsWith(TEMP_SUFFIX));
        ArrayList<String> retList = new ArrayList<String>();
        if (names != null) {
            HashSet<String> set = new HashSet<String>();
            for (String fileName : names) {
                set.add(fileName.replace(".profile", "").replace(TEMP_SUFFIX, ""));
            }
            retList.addAll(set);
        }
        return retList;
    }

    @Override
    public void reset() {
        if (SystemFileFactory.INSTANCE.getFile(this.userDirPath).mkdirs()) {
            logger.info("user info dir {} is created", (Object)this.userDirPath);
        } else if (!SystemFileFactory.INSTANCE.getFile(this.userDirPath).exists()) {
            logger.error("user info dir {} can not be created", (Object)this.userDirPath);
        }
    }
}

