/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure.tv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.datastructure.Cache;
import org.apache.iotdb.db.query.udf.datastructure.tv.ElasticSerializableBinaryTVList;
import org.apache.iotdb.db.query.udf.datastructure.tv.SerializableTVList;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;

public class ElasticSerializableTVList
implements PointCollector {
    protected TSDataType dataType;
    protected long queryId;
    protected float memoryLimitInMB;
    protected int internalTVListCapacity;
    protected int cacheSize;
    protected LRUCache cache;
    protected List<SerializableTVList> tvLists;
    protected List<BitMap> bitMaps;
    protected int size;
    protected int evictionUpperBound;

    public static ElasticSerializableTVList newElasticSerializableTVList(TSDataType dataType, long queryId, float memoryLimitInMB, int cacheSize) throws QueryProcessException {
        if (dataType.equals((Object)TSDataType.TEXT)) {
            return new ElasticSerializableBinaryTVList(queryId, memoryLimitInMB, cacheSize);
        }
        return new ElasticSerializableTVList(dataType, queryId, memoryLimitInMB, cacheSize);
    }

    protected ElasticSerializableTVList(TSDataType dataType, long queryId, float memoryLimitInMB, int cacheSize) throws QueryProcessException {
        this.dataType = dataType;
        this.queryId = queryId;
        this.memoryLimitInMB = memoryLimitInMB;
        int allocatableCapacity = SerializableTVList.calculateCapacity(dataType, memoryLimitInMB);
        this.internalTVListCapacity = allocatableCapacity / cacheSize;
        if (this.internalTVListCapacity == 0) {
            cacheSize = 1;
            this.internalTVListCapacity = allocatableCapacity;
        }
        this.cacheSize = cacheSize;
        this.cache = new LRUCache(cacheSize);
        this.bitMaps = new ArrayList<BitMap>();
        this.tvLists = new ArrayList<SerializableTVList>();
        this.size = 0;
        this.evictionUpperBound = 0;
    }

    protected ElasticSerializableTVList(TSDataType dataType, long queryId, float memoryLimitInMB, int internalTVListCapacity, int cacheSize) {
        this.dataType = dataType;
        this.queryId = queryId;
        this.memoryLimitInMB = memoryLimitInMB;
        this.internalTVListCapacity = internalTVListCapacity;
        this.cacheSize = cacheSize;
        this.cache = new LRUCache(cacheSize);
        this.bitMaps = new ArrayList<BitMap>();
        this.tvLists = new ArrayList<SerializableTVList>();
        this.size = 0;
        this.evictionUpperBound = 0;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public int size() {
        return this.size;
    }

    public boolean isNull(int index) throws IOException {
        return this.bitMaps.get(index / this.internalTVListCapacity).isMarked(index % this.internalTVListCapacity);
    }

    public long getTime(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getTimeByIndex(index % this.internalTVListCapacity);
    }

    public int getInt(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getIntByIndex(index % this.internalTVListCapacity);
    }

    public long getLong(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getLongByIndex(index % this.internalTVListCapacity);
    }

    public float getFloat(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getFloatByIndex(index % this.internalTVListCapacity);
    }

    public double getDouble(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getDoubleByIndex(index % this.internalTVListCapacity);
    }

    public boolean getBoolean(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getBooleanByIndex(index % this.internalTVListCapacity);
    }

    public Binary getBinary(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getBinaryByIndex(index % this.internalTVListCapacity);
    }

    public String getString(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getBinaryByIndex(index % this.internalTVListCapacity).getStringValue();
    }

    public void put(long timestamp, Object value) throws IOException, QueryProcessException {
        switch (this.dataType) {
            case INT32: {
                this.putInt(timestamp, (Integer)value);
                break;
            }
            case INT64: {
                this.putLong(timestamp, (Long)value);
                break;
            }
            case FLOAT: {
                this.putFloat(timestamp, ((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                this.putDouble(timestamp, (Double)value);
                break;
            }
            case BOOLEAN: {
                this.putBoolean(timestamp, (Boolean)value);
                break;
            }
            case TEXT: {
                this.putBinary(timestamp, (Binary)value);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataType));
            }
        }
    }

    @Override
    public void putInt(long timestamp, int value) throws IOException {
        this.checkExpansion();
        this.cache.get(this.size / this.internalTVListCapacity).putInt(timestamp, value);
        ++this.size;
    }

    @Override
    public void putLong(long timestamp, long value) throws IOException {
        this.checkExpansion();
        this.cache.get(this.size / this.internalTVListCapacity).putLong(timestamp, value);
        ++this.size;
    }

    @Override
    public void putFloat(long timestamp, float value) throws IOException {
        this.checkExpansion();
        this.cache.get(this.size / this.internalTVListCapacity).putFloat(timestamp, value);
        ++this.size;
    }

    @Override
    public void putDouble(long timestamp, double value) throws IOException {
        this.checkExpansion();
        this.cache.get(this.size / this.internalTVListCapacity).putDouble(timestamp, value);
        ++this.size;
    }

    @Override
    public void putBoolean(long timestamp, boolean value) throws IOException {
        this.checkExpansion();
        this.cache.get(this.size / this.internalTVListCapacity).putBoolean(timestamp, value);
        ++this.size;
    }

    @Override
    public void putBinary(long timestamp, Binary value) throws IOException, QueryProcessException {
        this.checkExpansion();
        this.cache.get(this.size / this.internalTVListCapacity).putBinary(timestamp, value);
        ++this.size;
    }

    @Override
    public void putString(long timestamp, String value) throws IOException, QueryProcessException {
        this.checkExpansion();
        this.cache.get(this.size / this.internalTVListCapacity).putBinary(timestamp, Binary.valueOf((String)value));
        ++this.size;
    }

    public void putNull(long timestamp) throws IOException, QueryProcessException {
        switch (this.dataType) {
            case INT32: {
                this.putInt(timestamp, 0);
                break;
            }
            case INT64: {
                this.putLong(timestamp, 0L);
                break;
            }
            case FLOAT: {
                this.putFloat(timestamp, 0.0f);
                break;
            }
            case DOUBLE: {
                this.putDouble(timestamp, 0.0);
                break;
            }
            case BOOLEAN: {
                this.putBoolean(timestamp, false);
                break;
            }
            case TEXT: {
                this.putBinary(timestamp, Binary.EMPTY_VALUE);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataType));
            }
        }
        this.bitMaps.get((this.size - 1) / this.internalTVListCapacity).mark((this.size - 1) % this.internalTVListCapacity);
    }

    private void checkExpansion() {
        if (this.size % this.internalTVListCapacity == 0) {
            this.tvLists.add(SerializableTVList.newSerializableTVList(this.dataType, this.queryId));
            this.bitMaps.add(new BitMap(this.internalTVListCapacity));
        }
    }

    public LayerPointReader constructPointReaderUsingTrivialEvictionStrategy() {
        return new LayerPointReader(){
            private int currentPointIndex = -1;

            @Override
            public boolean isConstantPointReader() {
                return false;
            }

            @Override
            public boolean next() {
                if (ElasticSerializableTVList.this.size - 1 <= this.currentPointIndex) {
                    return false;
                }
                ++this.currentPointIndex;
                return true;
            }

            @Override
            public void readyForNext() {
                ElasticSerializableTVList.this.setEvictionUpperBound(this.currentPointIndex + 1);
            }

            @Override
            public TSDataType getDataType() {
                return ElasticSerializableTVList.this.dataType;
            }

            @Override
            public long currentTime() throws IOException {
                return ElasticSerializableTVList.this.getTime(this.currentPointIndex);
            }

            @Override
            public int currentInt() throws IOException {
                return ElasticSerializableTVList.this.getInt(this.currentPointIndex);
            }

            @Override
            public long currentLong() throws IOException {
                return ElasticSerializableTVList.this.getLong(this.currentPointIndex);
            }

            @Override
            public float currentFloat() throws IOException {
                return ElasticSerializableTVList.this.getFloat(this.currentPointIndex);
            }

            @Override
            public double currentDouble() throws IOException {
                return ElasticSerializableTVList.this.getDouble(this.currentPointIndex);
            }

            @Override
            public boolean currentBoolean() throws IOException {
                return ElasticSerializableTVList.this.getBoolean(this.currentPointIndex);
            }

            @Override
            public Binary currentBinary() throws IOException {
                return ElasticSerializableTVList.this.getBinary(this.currentPointIndex);
            }

            @Override
            public boolean isCurrentNull() throws IOException {
                return ElasticSerializableTVList.this.isNull(this.currentPointIndex);
            }
        };
    }

    public void setEvictionUpperBound(int evictionUpperBound) {
        this.evictionUpperBound = evictionUpperBound;
    }

    private class LRUCache
    extends Cache {
        LRUCache(int capacity) {
            super(capacity);
        }

        BatchData get(int targetIndex) throws IOException {
            if (!this.removeFirstOccurrence(targetIndex)) {
                if (this.cacheCapacity <= this.cacheSize) {
                    int lastIndex = this.removeLast();
                    if (lastIndex < ElasticSerializableTVList.this.evictionUpperBound / ElasticSerializableTVList.this.internalTVListCapacity) {
                        ElasticSerializableTVList.this.tvLists.set(lastIndex, null);
                        ElasticSerializableTVList.this.bitMaps.set(lastIndex, null);
                    } else {
                        ElasticSerializableTVList.this.tvLists.get(lastIndex).serialize();
                    }
                }
                ElasticSerializableTVList.this.tvLists.get(targetIndex).deserialize();
            }
            this.addFirst(targetIndex);
            return ElasticSerializableTVList.this.tvLists.get(targetIndex);
        }
    }
}

