/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.limiter;

import org.apache.iotdb.commons.pipe.sink.limiter.GlobalRateLimiter;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.load.metrics.LoadTsFileCostMetricsSet;

public class LoadTsFileRateLimiter
extends GlobalRateLimiter {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();

    public void acquire(long bytes) {
        LoadTsFileCostMetricsSet.getInstance().recordDiskIO(bytes);
        super.acquire(bytes);
    }

    protected double getThroughputBytesPerSecond() {
        return CONFIG.getLoadWriteThroughputBytesPerSecond();
    }

    public static LoadTsFileRateLimiter getInstance() {
        return LoadTsFileRateLimiterHolder.INSTANCE;
    }

    private static class LoadTsFileRateLimiterHolder {
        private static final LoadTsFileRateLimiter INSTANCE = new LoadTsFileRateLimiter();

        private LoadTsFileRateLimiterHolder() {
        }
    }
}

