/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ExpressionSymbolInliner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SemiJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class TransformFilteringSemiJoinToInnerJoin
implements Rule<FilterNode> {
    private static final Capture<SemiJoinNode> SEMI_JOIN = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.semiJoin().capturedAs(SEMI_JOIN)));

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        SemiJoinNode semiJoin = captures.get(SEMI_JOIN);
        Symbol semiJoinSymbol = semiJoin.getSemiJoinOutput();
        Predicate<Expression> isSemiJoinSymbol = expression -> expression.equals(semiJoinSymbol.toSymbolReference());
        List<Expression> conjuncts = IrUtils.extractConjuncts(filterNode.getPredicate());
        if (conjuncts.stream().noneMatch(isSemiJoinSymbol)) {
            return Rule.Result.empty();
        }
        Expression filteredPredicate = IrUtils.and((Collection)conjuncts.stream().filter(isSemiJoinSymbol.negate()).collect(ImmutableList.toImmutableList()));
        Expression simplifiedPredicate = ExpressionSymbolInliner.inlineSymbols(symbol -> {
            if (symbol.equals(semiJoinSymbol)) {
                return BooleanLiteral.TRUE_LITERAL;
            }
            return symbol.toSymbolReference();
        }, filteredPredicate);
        Optional<Expression> joinFilter = simplifiedPredicate.equals(BooleanLiteral.TRUE_LITERAL) ? Optional.empty() : Optional.of(simplifiedPredicate);
        AggregationNode filteringSourceDistinct = AggregationNode.singleAggregation(context.getIdAllocator().genPlanNodeId(), semiJoin.getFilteringSource(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet((List<Symbol>)ImmutableList.of((Object)semiJoin.getFilteringSourceJoinSymbol())));
        JoinNode innerJoin = new JoinNode(semiJoin.getPlanNodeId(), JoinNode.JoinType.INNER, semiJoin.getSource(), filteringSourceDistinct, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(semiJoin.getSourceJoinSymbol(), semiJoin.getFilteringSourceJoinSymbol())), Optional.empty(), semiJoin.getSource().getOutputSymbols(), (List<Symbol>)ImmutableList.of(), joinFilter, Optional.empty());
        ProjectNode project = new ProjectNode(context.getIdAllocator().genPlanNodeId(), innerJoin, Assignments.builder().putIdentities(innerJoin.getOutputSymbols()).put(semiJoinSymbol, BooleanLiteral.TRUE_LITERAL).build());
        return Rule.Result.ofPlanNode(project);
    }
}

