/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.compatibility;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.tsfile.compatibility.DeserializeConfig;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.TsFileMetadata;
import org.apache.tsfile.utils.BloomFilter;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class CompatibilityUtils {
    public static DeserializeConfig v3DeserializeConfig = new DeserializeConfig();

    private CompatibilityUtils() {
    }

    public static TsFileMetadata deserializeTsFileMetadataFromV3(ByteBuffer buffer, DeserializeConfig context) {
        TsFileMetadata fileMetaData = new TsFileMetadata();
        MetadataIndexNode metadataIndexNode = context.deviceMetadataIndexNodeBufferDeserializer.deserialize(buffer, context);
        fileMetaData.setTableMetadataIndexNodeMap(Collections.singletonMap("", metadataIndexNode));
        long metaOffset = ReadWriteIOUtils.readLong(buffer);
        fileMetaData.setMetaOffset(metaOffset);
        if (buffer.hasRemaining()) {
            byte[] bytes = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(buffer);
            int filterSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
            int hashFunctionSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
            fileMetaData.setBloomFilter(BloomFilter.buildBloomFilter(bytes, filterSize, hashFunctionSize));
        }
        return fileMetaData;
    }

    static {
        CompatibilityUtils.v3DeserializeConfig.versionNumber = (byte)3;
        CompatibilityUtils.v3DeserializeConfig.tsFileMetadataBufferDeserializer = CompatibilityUtils::deserializeTsFileMetadataFromV3;
        CompatibilityUtils.v3DeserializeConfig.cacheTableSchemaMapTsFileMetadataBufferDeserializer = CompatibilityUtils::deserializeTsFileMetadataFromV3;
        CompatibilityUtils.v3DeserializeConfig.deviceIDBufferDeserializer = (buffer, context) -> {
            PlainDeviceID deviceID = PlainDeviceID.deserialize(buffer);
            return deviceID.convertToStringArrayDeviceId();
        };
        CompatibilityUtils.v3DeserializeConfig.deviceIDStreamDeserializer = (stream, context) -> {
            PlainDeviceID deviceID = PlainDeviceID.deserialize(stream);
            return deviceID.convertToStringArrayDeviceId();
        };
    }
}

