/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.commons.udf.builtin.UDTFDerivative;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFCommonDerivative
extends UDTFDerivative {
    @Override
    protected void doTransform(Row row, PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        long currentTime = row.getTime();
        double timeDelta = (double)currentTime - (double)this.previousTime;
        switch (this.dataType) {
            case INT32: {
                int currentInt = row.getInt(0);
                collector.putDouble(currentTime, (double)(currentInt - this.previousInt) / timeDelta);
                this.previousInt = currentInt;
                break;
            }
            case INT64: {
                long currentLong = row.getLong(0);
                collector.putDouble(currentTime, (double)(currentLong - this.previousLong) / timeDelta);
                this.previousLong = currentLong;
                break;
            }
            case FLOAT: {
                float currentFloat = row.getFloat(0);
                collector.putDouble(currentTime, (double)(currentFloat - this.previousFloat) / timeDelta);
                this.previousFloat = currentFloat;
                break;
            }
            case DOUBLE: {
                double currentDouble = row.getDouble(0);
                collector.putDouble(currentTime, (currentDouble - this.previousDouble) / timeDelta);
                this.previousDouble = currentDouble;
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
            }
        }
        this.previousTime = currentTime;
    }
}

