/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.visitor;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;

public class PipeStatementTreePatternParseVisitor
extends StatementVisitor<Optional<Statement>, IoTDBTreePattern> {
    @Override
    public Optional<Statement> visitNode(StatementNode statement, IoTDBTreePattern pattern) {
        return Optional.of((Statement)statement);
    }

    @Override
    public Optional<Statement> visitCreateTimeseries(CreateTimeSeriesStatement statement, IoTDBTreePattern pattern) {
        return pattern.matchesMeasurement(statement.getPath().getIDeviceID(), statement.getPath().getMeasurement()) ? Optional.of(statement) : Optional.empty();
    }

    @Override
    public Optional<Statement> visitCreateAlignedTimeseries(CreateAlignedTimeSeriesStatement statement, IoTDBTreePattern pattern) {
        int[] filteredIndexes = IntStream.range(0, statement.getMeasurements().size()).filter(index -> pattern.matchesMeasurement(statement.getDevicePath().getIDeviceIDAsFullDevice(), statement.getMeasurements().get(index))).toArray();
        if (filteredIndexes.length == 0) {
            return Optional.empty();
        }
        CreateAlignedTimeSeriesStatement targetCreateAlignedTimeSeriesStatement = new CreateAlignedTimeSeriesStatement();
        targetCreateAlignedTimeSeriesStatement.setDevicePath(statement.getDevicePath());
        Arrays.stream(filteredIndexes).forEach(index -> {
            targetCreateAlignedTimeSeriesStatement.addMeasurement(statement.getMeasurements().get(index));
            targetCreateAlignedTimeSeriesStatement.addDataType(statement.getDataTypes().get(index));
            targetCreateAlignedTimeSeriesStatement.addEncoding(statement.getEncodings().get(index));
            targetCreateAlignedTimeSeriesStatement.addCompressor(statement.getCompressors().get(index));
            targetCreateAlignedTimeSeriesStatement.addTagsList(statement.getTagsList().get(index));
            targetCreateAlignedTimeSeriesStatement.addAttributesList(statement.getAttributesList().get(index));
            targetCreateAlignedTimeSeriesStatement.addAliasList(statement.getAliasList().get(index));
        });
        return Optional.of(targetCreateAlignedTimeSeriesStatement);
    }

    @Override
    public Optional<Statement> visitAlterTimeSeries(AlterTimeSeriesStatement alterTimeSeriesStatement, IoTDBTreePattern pattern) {
        return pattern.matchesMeasurement(alterTimeSeriesStatement.getPath().getIDeviceID(), alterTimeSeriesStatement.getPath().getMeasurement()) ? Optional.of(alterTimeSeriesStatement) : Optional.empty();
    }

    @Override
    public Optional<Statement> visitActivateTemplate(ActivateTemplateStatement activateTemplateStatement, IoTDBTreePattern pattern) {
        return pattern.matchDevice(activateTemplateStatement.getPath().getFullPath()) ? Optional.of(activateTemplateStatement) : Optional.empty();
    }

    @Override
    public Optional<Statement> visitCreateLogicalView(CreateLogicalViewStatement createLogicalViewStatement, IoTDBTreePattern pattern) {
        int[] filteredIndexes = IntStream.range(0, createLogicalViewStatement.getTargetPathList().size()).filter(index -> pattern.matchesMeasurement(createLogicalViewStatement.getTargetPathList().get(index).getIDeviceIDAsFullDevice(), createLogicalViewStatement.getTargetPathList().get(index).getMeasurement())).toArray();
        if (filteredIndexes.length == 0) {
            return Optional.empty();
        }
        createLogicalViewStatement.setTargetFullPaths(IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, createLogicalViewStatement.getTargetPathList()));
        createLogicalViewStatement.setViewExpressions(IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, createLogicalViewStatement.getViewExpressions()));
        return Optional.of(createLogicalViewStatement);
    }
}

