/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor;

import java.util.List;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ReconstructVisitor;

public class ExpressionNormalizeVisitor
extends ReconstructVisitor<Void> {
    private final boolean removeViewPath;

    public ExpressionNormalizeVisitor(boolean removeViewPath) {
        this.removeViewPath = removeViewPath;
    }

    @Override
    public Expression process(Expression expression, Void context) {
        Expression resultExpression = expression.accept(this, context);
        if (this.removeViewPath) {
            resultExpression.setViewPath(null);
        }
        return resultExpression;
    }

    @Override
    public Expression visitFunctionExpression(FunctionExpression functionExpression, Void context) {
        List<Expression> reconstructedChildren = this.getReconstructedChildren(functionExpression, context);
        return ExpressionUtils.reconstructFunctionExpressionWithLowerCaseFunctionName(functionExpression, reconstructedChildren);
    }

    @Override
    public Expression visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Void context) {
        PartialPath rawPath = timeSeriesOperand.getPath();
        PartialPath newPath = rawPath.copy();
        if (newPath.isMeasurementAliasExists()) {
            ((MeasurementPath)newPath).removeMeasurementAlias();
        }
        TimeSeriesOperand newOperand = new TimeSeriesOperand(newPath, timeSeriesOperand.getType());
        if (timeSeriesOperand.isViewExpression()) {
            newOperand.setViewPath(timeSeriesOperand.getViewPath());
        }
        return newOperand;
    }
}

