/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Lookup;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.QueryCardinalityUtil;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureTranslator;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.tsfile.read.common.type.Type;

public class TransformUncorrelatedSubqueryToJoin
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Pattern.empty(Patterns.CorrelatedJoin.correlation()));

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        if (correlatedJoinNode.getJoinType() == JoinNode.JoinType.INNER || correlatedJoinNode.getJoinType() == JoinNode.JoinType.LEFT) {
            return Rule.Result.ofPlanNode(this.rewriteToJoin(correlatedJoinNode, correlatedJoinNode.getJoinType(), correlatedJoinNode.getFilter(), context.getLookup()));
        }
        Preconditions.checkState((correlatedJoinNode.getJoinType() == JoinNode.JoinType.RIGHT || correlatedJoinNode.getJoinType() == JoinNode.JoinType.FULL ? 1 : 0) != 0, (Object)("unexpected CorrelatedJoin type: " + (Object)((Object)correlatedJoinNode.getType())));
        JoinNode.JoinType type = correlatedJoinNode.getJoinType() == JoinNode.JoinType.RIGHT ? JoinNode.JoinType.INNER : JoinNode.JoinType.LEFT;
        JoinNode joinNode = this.rewriteToJoin(correlatedJoinNode, type, BooleanLiteral.TRUE_LITERAL, context.getLookup());
        if (correlatedJoinNode.getFilter().equals(BooleanLiteral.TRUE_LITERAL)) {
            return Rule.Result.ofPlanNode(joinNode);
        }
        if (correlatedJoinNode.getJoinType() == JoinNode.JoinType.RIGHT) {
            Assignments.Builder assignments = Assignments.builder();
            assignments.putIdentities((Iterable<Symbol>)Sets.intersection((Set)ImmutableSet.copyOf(correlatedJoinNode.getSubquery().getOutputSymbols()), (Set)ImmutableSet.copyOf(correlatedJoinNode.getOutputSymbols())));
            for (Symbol inputSymbol : Sets.intersection((Set)ImmutableSet.copyOf(correlatedJoinNode.getInput().getOutputSymbols()), (Set)ImmutableSet.copyOf(correlatedJoinNode.getOutputSymbols()))) {
                Type inputType = context.getSymbolAllocator().getTypes().getTableModelType(inputSymbol);
                assignments.put(inputSymbol, new IfExpression(correlatedJoinNode.getFilter(), inputSymbol.toSymbolReference(), new Cast(new NullLiteral(), TypeSignatureTranslator.toSqlType(inputType))));
            }
            ProjectNode projectNode = new ProjectNode(context.getIdAllocator().genPlanNodeId(), joinNode, assignments.build());
            return Rule.Result.ofPlanNode(projectNode);
        }
        return Rule.Result.empty();
    }

    private JoinNode rewriteToJoin(CorrelatedJoinNode parent, JoinNode.JoinType type, Expression filter, Lookup lookup) {
        if (type == JoinNode.JoinType.LEFT && QueryCardinalityUtil.extractCardinality(parent.getSubquery(), lookup).isAtLeastScalar() && filter.equals(BooleanLiteral.TRUE_LITERAL)) {
            type = JoinNode.JoinType.INNER;
        }
        return new JoinNode(parent.getPlanNodeId(), type, parent.getInput(), parent.getSubquery(), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), Optional.empty(), parent.getInput().getOutputSymbols(), parent.getSubquery().getOutputSymbols(), filter.equals(BooleanLiteral.TRUE_LITERAL) ? Optional.empty() : Optional.of(filter), Optional.empty());
    }
}

