/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.intermediate;

import java.io.IOException;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.LayerRowWindowReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.adapter.ElasticSerializableTVListBackedSingleColumnWindow;
import org.apache.iotdb.db.queryengine.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.LayerCacheUtils;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TransformUtils;
import org.apache.iotdb.db.queryengine.transformation.datastructure.iterator.TVListForwardIterator;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.util.ValueRecorder;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.customizer.strategy.SessionTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.StateWindowAccessStrategy;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInputSingleReferenceLayer
extends IntermediateLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleInputSingleReferenceLayer.class);
    private final LayerReader parentLayerReader;
    private final TSDataType dataType;

    public SingleInputSingleReferenceLayer(Expression expression, String queryId, float memoryBudgetInMB, LayerReader parentLayerReader) {
        super(expression, queryId, memoryBudgetInMB);
        this.parentLayerReader = parentLayerReader;
        this.dataType = parentLayerReader.getDataTypes()[0];
    }

    @Override
    public LayerReader constructReader() {
        return this.parentLayerReader;
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingSizeWindowReader(final SlidingSizeWindowAccessStrategy strategy, final float memoryBudgetInMB) {
        return new LayerRowWindowReader(){
            private final int windowSize;
            private final int slidingStep;
            private final ElasticSerializableTVList tvList;
            private final ElasticSerializableTVListBackedSingleColumnWindow window;
            private boolean hasCached;
            private int beginIndex;
            {
                this.windowSize = strategy.getWindowSize();
                this.slidingStep = strategy.getSlidingStep();
                this.tvList = ElasticSerializableTVList.construct(SingleInputSingleReferenceLayer.this.dataType, SingleInputSingleReferenceLayer.this.queryId, memoryBudgetInMB, 2);
                this.window = new ElasticSerializableTVListBackedSingleColumnWindow(this.tvList);
                this.hasCached = false;
                this.beginIndex = -this.slidingStep;
            }

            @Override
            public YieldableState yield() throws Exception {
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                if (this.beginIndex < 0 || endIndex < 0) {
                    LOGGER.warn("LayerRowWindowReader index overflow. beginIndex: {}, endIndex: {}, windowSize: {}.", new Object[]{this.beginIndex, endIndex, this.windowSize});
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                int pointsToBeCollected = endIndex - this.tvList.size();
                if (pointsToBeCollected > 0) {
                    YieldableState yieldableState = LayerCacheUtils.yieldPoints(SingleInputSingleReferenceLayer.this.parentLayerReader, this.tvList, pointsToBeCollected);
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        this.beginIndex -= this.slidingStep;
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (this.tvList.size() <= this.beginIndex) {
                        return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                    }
                    endIndex = Math.min(endIndex, this.tvList.size());
                }
                this.window.seek(this.beginIndex, endIndex, this.tvList.getTime(this.beginIndex), this.tvList.getTime(endIndex - 1));
                this.hasCached = true;
                return YieldableState.YIELDABLE;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.tvList.setEvictionUpperBound(this.beginIndex + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputSingleReferenceLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return this.window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingTimeWindowReader(final SlidingTimeWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long timeInterval = strategy.getTimeInterval();
        final long slidingStep = strategy.getSlidingStep();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final ElasticSerializableTVList tvList = ElasticSerializableTVList.construct(this.dataType, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(tvList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private boolean hasCached = false;
            private long nextWindowTimeBegin = strategy.getDisplayWindowBegin();
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 0;
            private long currentEndTime = Long.MAX_VALUE;
            private final TVListForwardIterator beginIterator = tvList.constructIterator();
            private Column cachedBeginTimeColumn;
            private int cachedBeginConsumed;
            private Column cachedEndTimeColumn;
            private int cachedEndConsumed;

            @Override
            public YieldableState yield() throws Exception {
                if (this.isFirstIteration) {
                    if (tvList.size() == 0) {
                        YieldableState state = SingleInputSingleReferenceLayer.this.parentLayerReader.yield();
                        if (state != YieldableState.YIELDABLE) {
                            return state;
                        }
                        Column[] columns = SingleInputSingleReferenceLayer.this.parentLayerReader.current();
                        TimeColumn times = (TimeColumn)columns[1];
                        Column values = columns[0];
                        tvList.putColumn((Column)times, values);
                        SingleInputSingleReferenceLayer.this.parentLayerReader.consumedAll();
                        this.cachedEndTimeColumn = times;
                    }
                    if (this.nextWindowTimeBegin == Long.MIN_VALUE) {
                        this.nextWindowTimeBegin = this.cachedEndTimeColumn.getLong(0);
                    }
                    boolean bl = this.hasAtLeastOneRow = tvList.size() != 0;
                    if (this.hasAtLeastOneRow) {
                        this.currentEndTime = this.cachedEndTimeColumn.getLong(this.cachedEndTimeColumn.getPositionCount() - 1);
                    }
                    this.isFirstIteration = false;
                }
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (this.currentEndTime < nextWindowTimeEnd) {
                    YieldableState state = SingleInputSingleReferenceLayer.this.parentLayerReader.yield();
                    if (state == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (state == YieldableState.NOT_YIELDABLE_NO_MORE_DATA) break;
                    Column[] columns = SingleInputSingleReferenceLayer.this.parentLayerReader.current();
                    TimeColumn times = (TimeColumn)columns[1];
                    Column values = columns[0];
                    tvList.putColumn((Column)times, values);
                    SingleInputSingleReferenceLayer.this.parentLayerReader.consumedAll();
                    this.currentEndTime = times.getEndTime();
                    this.nextIndexEnd += this.cachedEndTimeColumn.getPositionCount() - this.cachedEndConsumed;
                    this.cachedEndTimeColumn = times;
                    this.cachedEndConsumed = 0;
                }
                while (this.cachedEndConsumed < this.cachedEndTimeColumn.getPositionCount() && this.cachedEndTimeColumn.getLong(this.cachedEndConsumed) < nextWindowTimeEnd) {
                    ++this.cachedEndConsumed;
                    ++this.nextIndexEnd;
                }
                boolean findNextIndexBegin = false;
                while (!findNextIndexBegin) {
                    while (this.cachedBeginTimeColumn != null && this.cachedBeginConsumed < this.cachedBeginTimeColumn.getPositionCount()) {
                        if (this.cachedBeginTimeColumn.getLong(this.cachedBeginConsumed) >= this.nextWindowTimeBegin) {
                            findNextIndexBegin = true;
                            break;
                        }
                        ++this.cachedBeginConsumed;
                        ++this.nextIndexBegin;
                    }
                    if (findNextIndexBegin) continue;
                    if (this.beginIterator.hasNext()) {
                        this.beginIterator.next();
                        this.cachedBeginConsumed = 0;
                        this.cachedBeginTimeColumn = this.beginIterator.currentTimes();
                        continue;
                    }
                    findNextIndexBegin = true;
                }
                if (this.nextIndexEnd == this.nextIndexBegin && nextWindowTimeEnd < this.cachedEndTimeColumn.getLong(this.cachedEndTimeColumn.getPositionCount() - 1)) {
                    window.setEmptyWindow(this.nextWindowTimeBegin, nextWindowTimeEnd);
                    return YieldableState.YIELDABLE;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != this.nextIndexEnd || this.nextIndexEnd != tvList.size();
                return this.hasCached ? YieldableState.YIELDABLE : YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.nextWindowTimeBegin += slidingStep;
                tvList.setEvictionUpperBound(this.nextIndexBegin + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputSingleReferenceLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSessionTimeWindowReader(SessionTimeWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long displayWindowBegin = strategy.getDisplayWindowBegin();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final long sessionTimeGap = strategy.getSessionTimeGap();
        final ElasticSerializableTVList tvList = ElasticSerializableTVList.construct(this.dataType, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(tvList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private long nextWindowTimeBegin = displayWindowBegin;
            private long nextWindowTimeEnd = 0L;
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 0;
            private TimeColumn cachedTimes;
            private int cachedConsumed;

            @Override
            public YieldableState yield() throws Exception {
                YieldableState state;
                if (this.isFirstIteration && (state = this.yieldInFirstIteration()) != YieldableState.YIELDABLE) {
                    return state;
                }
                if (!this.hasAtLeastOneRow || this.nextWindowTimeBegin >= displayWindowEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                long curTime = this.cachedTimes.getLong(this.cachedConsumed);
                if (this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                    ++this.nextIndexEnd;
                    ++this.cachedConsumed;
                }
                boolean findWindow = false;
                while (!findWindow && this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                    while (this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                        long nextTime = this.cachedTimes.getLong(this.cachedConsumed);
                        if (nextTime >= displayWindowEnd) {
                            findWindow = true;
                            break;
                        }
                        if (nextTime - curTime > sessionTimeGap) {
                            findWindow = true;
                            break;
                        }
                        ++this.nextIndexEnd;
                        ++this.cachedConsumed;
                        curTime = nextTime;
                    }
                    if (findWindow || this.cachedTimes.getEndTime() >= displayWindowEnd) continue;
                    YieldableState state2 = this.yieldAndCache();
                    if (state2 == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (state2 != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    break;
                }
                this.nextWindowTimeEnd = tvList.getTime(this.nextIndexEnd - 1);
                if (this.nextIndexBegin == this.nextIndexEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeEnd);
                return YieldableState.YIELDABLE;
            }

            private YieldableState yieldInFirstIteration() throws Exception {
                YieldableState state;
                if (tvList.size() == 0 && (state = this.yieldAndCache()) != YieldableState.YIELDABLE) {
                    return state;
                }
                this.nextWindowTimeBegin = Math.max(displayWindowBegin, this.cachedTimes.getStartTime());
                this.hasAtLeastOneRow = tvList.size() != 0;
                this.isFirstIteration = false;
                long currentEndTime = this.cachedTimes.getEndTime();
                while (currentEndTime < this.nextWindowTimeBegin) {
                    this.cachedConsumed = this.cachedTimes.getPositionCount();
                    this.nextIndexBegin += this.cachedConsumed;
                    YieldableState state2 = this.yieldAndCache();
                    if (state2 == YieldableState.YIELDABLE) continue;
                    this.nextIndexEnd = this.nextIndexBegin;
                    return state2;
                }
                while (this.cachedConsumed < this.cachedTimes.getPositionCount() && this.cachedTimes.getLong(this.cachedConsumed) < this.nextWindowTimeBegin) {
                    ++this.cachedConsumed;
                    ++this.nextIndexBegin;
                }
                this.nextIndexEnd = this.nextIndexBegin;
                return YieldableState.YIELDABLE;
            }

            private YieldableState yieldAndCache() throws Exception {
                YieldableState state = SingleInputSingleReferenceLayer.this.parentLayerReader.yield();
                if (state != YieldableState.YIELDABLE) {
                    return state;
                }
                Column[] columns = SingleInputSingleReferenceLayer.this.parentLayerReader.current();
                TimeColumn times = (TimeColumn)columns[1];
                Column values = columns[0];
                tvList.putColumn((Column)times, values);
                SingleInputSingleReferenceLayer.this.parentLayerReader.consumedAll();
                this.cachedTimes = times;
                this.cachedConsumed = 0;
                return YieldableState.YIELDABLE;
            }

            @Override
            public void readyForNext() throws IOException {
                if (this.nextIndexEnd < tvList.size()) {
                    this.nextWindowTimeBegin = tvList.getTime(this.nextIndexEnd);
                }
                tvList.setEvictionUpperBound(this.nextIndexBegin + 1);
                this.nextIndexBegin = this.nextIndexEnd;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputSingleReferenceLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowStateWindowReader(StateWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long displayWindowBegin = strategy.getDisplayWindowBegin();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final double delta = strategy.getDelta();
        final ElasticSerializableTVList tvList = ElasticSerializableTVList.construct(this.dataType, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(tvList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private long nextWindowTimeBegin = displayWindowBegin;
            private long nextWindowTimeEnd = 0L;
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 0;
            private TimeColumn cachedTimes;
            private Column cachedValues;
            private int cachedConsumed;
            private final ValueRecorder valueRecorder = new ValueRecorder();

            @Override
            public YieldableState yield() throws Exception {
                YieldableState state;
                if (this.isFirstIteration && (state = this.yieldInFirstIteration()) != YieldableState.YIELDABLE) {
                    return state;
                }
                if (!this.hasAtLeastOneRow || this.nextWindowTimeBegin >= displayWindowEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                if (this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                    ++this.nextIndexEnd;
                    ++this.cachedConsumed;
                }
                boolean findWindow = false;
                while (!findWindow && this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                    while (this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                        long nextTime = this.cachedTimes.getLong(this.cachedConsumed);
                        if (nextTime >= displayWindowEnd) {
                            findWindow = true;
                            break;
                        }
                        if (TransformUtils.splitWindowForStateWindow(SingleInputSingleReferenceLayer.this.dataType, this.valueRecorder, delta, this.cachedValues, this.cachedConsumed)) {
                            findWindow = true;
                            break;
                        }
                        ++this.nextIndexEnd;
                        ++this.cachedConsumed;
                    }
                    if (findWindow || this.cachedTimes.getEndTime() >= displayWindowEnd) continue;
                    YieldableState state2 = this.yieldAndCache();
                    if (state2 == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (state2 != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    break;
                }
                this.nextWindowTimeEnd = tvList.getTime(this.nextIndexEnd - 1);
                if (this.nextIndexBegin == this.nextIndexEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeEnd);
                return YieldableState.YIELDABLE;
            }

            private YieldableState yieldInFirstIteration() throws Exception {
                YieldableState state;
                if (tvList.size() == 0 && (state = this.yieldAndCache()) != YieldableState.YIELDABLE) {
                    return state;
                }
                this.nextWindowTimeBegin = Math.max(displayWindowBegin, this.cachedTimes.getStartTime());
                this.hasAtLeastOneRow = tvList.size() != 0;
                this.isFirstIteration = false;
                long currentEndTime = this.cachedTimes.getEndTime();
                while (currentEndTime < this.nextWindowTimeBegin) {
                    this.cachedConsumed = this.cachedTimes.getPositionCount();
                    this.nextIndexBegin += this.cachedConsumed;
                    YieldableState state2 = this.yieldAndCache();
                    if (state2 == YieldableState.YIELDABLE) continue;
                    this.nextIndexEnd = this.nextIndexBegin;
                    return state2;
                }
                while (this.cachedConsumed < this.cachedTimes.getPositionCount() && this.cachedTimes.getLong(this.cachedConsumed) < this.nextWindowTimeBegin) {
                    ++this.cachedConsumed;
                    ++this.nextIndexBegin;
                }
                this.nextIndexEnd = this.nextIndexBegin;
                return YieldableState.YIELDABLE;
            }

            private YieldableState yieldAndCache() throws Exception {
                YieldableState state = SingleInputSingleReferenceLayer.this.parentLayerReader.yield();
                if (state != YieldableState.YIELDABLE) {
                    return state;
                }
                Column[] columns = SingleInputSingleReferenceLayer.this.parentLayerReader.current();
                TimeColumn times = (TimeColumn)columns[1];
                Column values = columns[0];
                tvList.putColumn((Column)times, values);
                SingleInputSingleReferenceLayer.this.parentLayerReader.consumedAll();
                this.cachedTimes = times;
                this.cachedValues = values;
                this.cachedConsumed = 0;
                return YieldableState.YIELDABLE;
            }

            @Override
            public void readyForNext() throws IOException {
                if (this.nextIndexEnd < tvList.size()) {
                    this.nextWindowTimeBegin = tvList.getTime(this.nextIndexEnd);
                }
                tvList.setEvictionUpperBound(this.nextIndexBegin + 1);
                this.nextIndexBegin = this.nextIndexEnd;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputSingleReferenceLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }
}

