/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.ainode.rpc.thrift.TShowLoadedModelsResp;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.BytesUtils;

public class ShowLoadedModelsTask
implements IConfigTask {
    private final List<String> deviceIdList;

    public ShowLoadedModelsTask(List<String> deviceIdList) {
        this.deviceIdList = deviceIdList;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showLoadedModels(this.deviceIdList);
    }

    public static void buildTsBlock(TShowLoadedModelsResp resp, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showLoadedModelsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (String deviceId : resp.getDeviceLoadedModelsMap().keySet()) {
            for (Map.Entry instanceEntry : ((Map)resp.getDeviceLoadedModelsMap().get(deviceId)).entrySet()) {
                String modelId = (String)instanceEntry.getKey();
                Integer count = (Integer)instanceEntry.getValue();
                builder.getTimeColumnBuilder().writeLong(0L);
                builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)deviceId));
                builder.getColumnBuilder(1).writeBinary(BytesUtils.valueOf((String)modelId));
                builder.getColumnBuilder(2).writeInt(count.intValue());
                builder.declarePosition();
            }
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowLoadedModelsHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

