/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class EncodingInferenceUtils {
    private EncodingInferenceUtils() {
    }

    public static TSEncoding getDefaultEncoding(TSDataType dataType) {
        IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();
        switch (dataType) {
            case BOOLEAN: {
                return conf.getDefaultBooleanEncoding();
            }
            case DATE: 
            case INT32: {
                return conf.getDefaultInt32Encoding();
            }
            case TIMESTAMP: 
            case INT64: {
                return conf.getDefaultInt64Encoding();
            }
            case FLOAT: {
                return conf.getDefaultFloatEncoding();
            }
            case DOUBLE: {
                return conf.getDefaultDoubleEncoding();
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return conf.getDefaultTextEncoding();
            }
        }
        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
    }
}

