/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.memory.metadata;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.vault.metadata.DeletedMessageMetadataVault;
import org.apache.james.vault.metadata.DeletedMessageWithStorageInformation;
import org.apache.james.vault.metadata.StorageInformation;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MemoryDeletedMessageMetadataVault
implements DeletedMessageMetadataVault {
    private final Table<BucketName, Username, Map<MessageId, DeletedMessageWithStorageInformation>> table = HashBasedTable.create();

    @Override
    public Publisher<Void> store(DeletedMessageWithStorageInformation deletedMessage) {
        BucketName bucketName = deletedMessage.getStorageInformation().getBucketName();
        Username owner = deletedMessage.getDeletedMessage().getOwner();
        MessageId messageId = deletedMessage.getDeletedMessage().getMessageId();
        return Mono.fromRunnable(() -> {
            Table<BucketName, Username, Map<MessageId, DeletedMessageWithStorageInformation>> table = this.table;
            synchronized (table) {
                Map<MessageId, DeletedMessageWithStorageInformation> userVault = this.userVault(bucketName, owner);
                userVault.put(messageId, deletedMessage);
                this.table.put((Object)bucketName, (Object)owner, userVault);
            }
        });
    }

    @Override
    public Publisher<Void> removeMetadataRelatedToBucket(BucketName bucketName) {
        return Mono.fromRunnable(() -> {
            Table<BucketName, Username, Map<MessageId, DeletedMessageWithStorageInformation>> table = this.table;
            synchronized (table) {
                this.table.row((Object)bucketName).clear();
            }
        });
    }

    @Override
    public Publisher<Void> remove(BucketName bucketName, Username username, MessageId messageId) {
        return Mono.fromRunnable(() -> {
            Table<BucketName, Username, Map<MessageId, DeletedMessageWithStorageInformation>> table = this.table;
            synchronized (table) {
                this.userVault(bucketName, username).remove(messageId);
            }
        });
    }

    @Override
    public Publisher<StorageInformation> retrieveStorageInformation(Username username, MessageId messageId) {
        return Flux.from(this.listRelatedBuckets()).concatMap(bucket -> {
            Table<BucketName, Username, Map<MessageId, DeletedMessageWithStorageInformation>> table = this.table;
            synchronized (table) {
                return Mono.justOrEmpty((Object)this.userVault((BucketName)bucket, username).get(messageId));
            }
        }).map(DeletedMessageWithStorageInformation::getStorageInformation).next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Publisher<DeletedMessageWithStorageInformation> listMessages(BucketName bucketName, Username username) {
        Table<BucketName, Username, Map<MessageId, DeletedMessageWithStorageInformation>> table = this.table;
        synchronized (table) {
            return Flux.fromIterable((Iterable)((Iterable)Optional.ofNullable((Map)this.table.get((Object)bucketName, (Object)username)).map(Map::values).map(ImmutableList::copyOf).orElse(ImmutableList.of())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Publisher<BucketName> listRelatedBuckets() {
        Table<BucketName, Username, Map<MessageId, DeletedMessageWithStorageInformation>> table = this.table;
        synchronized (table) {
            return Flux.fromIterable((Iterable)ImmutableSet.copyOf((Collection)this.table.rowKeySet()));
        }
    }

    private Map<MessageId, DeletedMessageWithStorageInformation> userVault(BucketName bucketName, Username owner) {
        return Optional.ofNullable((Map)this.table.get((Object)bucketName, (Object)owner)).orElse(new HashMap());
    }
}

