/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.components;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.schemabuilder.CreateType;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class CassandraType {
    private final String name;
    private final CreateType createStatement;

    public CassandraType(String name, CreateType createStatement) {
        this.name = name;
        this.createStatement = createStatement;
    }

    public String getName() {
        return this.name;
    }

    public InitializationStatus initialize(KeyspaceMetadata keyspaceMetadata, Session session) {
        if (keyspaceMetadata.getUserType(this.name) != null) {
            return InitializationStatus.ALREADY_DONE;
        }
        session.execute((Statement)this.createStatement);
        return InitializationStatus.FULL;
    }

    public final boolean equals(Object o) {
        if (o instanceof CassandraType) {
            CassandraType that = (CassandraType)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.createStatement, that.createStatement);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.createStatement);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("createStatement", (Object)this.createStatement).toString();
    }

    public static enum InitializationStatus {
        ALREADY_DONE,
        PARTIAL,
        FULL;


        public InitializationStatus reduce(InitializationStatus other) {
            if (this == other) {
                return this;
            }
            return PARTIAL;
        }
    }
}

