/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.annotations.VisibleForTesting;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.InvalidRegexException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.utils.ErrorResponder;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.Service;
import spark.Spark;

public class RegexMappingRoutes
implements Routes {
    static final String BASE_PATH = "/mappings/regex";
    static final String MAPPING_SOURCE_PARAM = ":mappingSource";
    static final String REGEX_PARAM = ":regex";
    static final String ADD_ADDRESS_MAPPING_PATH = "/mappings/regex/:mappingSource/targets/:regex";
    static final String REMOVE_ADDRESS_MAPPING_PATH = "/mappings/regex/:mappingSource/targets/:regex";
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    @VisibleForTesting
    RegexMappingRoutes(RecipientRewriteTable recipientRewriteTable) {
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        service.post("/mappings/regex/:mappingSource/targets/:regex", this::addRegexMapping);
        service.delete("/mappings/regex/:mappingSource/targets/:regex", this::removeRegexMapping);
    }

    private HaltException addRegexMapping(Request request, Response response) throws Exception {
        try {
            MappingSource mappingSource = this.extractMappingSource(request);
            String regex = URLDecoder.decode(request.params(REGEX_PARAM), StandardCharsets.UTF_8.toString());
            this.recipientRewriteTable.addRegexMapping(mappingSource, regex);
        }
        catch (InvalidRegexException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(e.getMessage()).haltError();
        }
        return Spark.halt((int)204);
    }

    private HaltException removeRegexMapping(Request request, Response response) throws Exception {
        try {
            MappingSource mappingSource = MappingSource.parse((String)request.params(MAPPING_SOURCE_PARAM));
            String regex = URLDecoder.decode(request.params(REGEX_PARAM), StandardCharsets.UTF_8.toString());
            this.recipientRewriteTable.removeRegexMapping(mappingSource, regex);
        }
        catch (RecipientRewriteTableException e) {
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message(e.getMessage()).haltError();
        }
        return Spark.halt((int)204);
    }

    private MappingSource extractMappingSource(Request request) {
        try {
            return MappingSource.fromUser((Username)Username.of((String)request.params(MAPPING_SOURCE_PARAM)));
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid `source` field.").haltError();
        }
    }
}

