/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra;

import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.cassandra.GhostMailbox;
import org.apache.james.mailbox.events.MailboxEvents;

public class MailboxOperationLoggingListener
implements EventListener.GroupEventListener {
    public static final String ADDED = "Added";
    public static final String REMOVED = "Removed";
    private static final Group GROUP = new MailboxOperationLoggingListenerGroup();

    public Group getDefaultGroup() {
        return GROUP;
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.MailboxRenamed || event instanceof MailboxEvents.MailboxDeletion || event instanceof MailboxEvents.MailboxAdded;
    }

    public void event(Event event) {
        if (event instanceof MailboxEvents.MailboxRenamed) {
            MailboxEvents.MailboxRenamed mailboxRenamed = (MailboxEvents.MailboxRenamed)event;
            GhostMailbox.logger().field("mailboxId", mailboxRenamed.getMailboxId().serialize()).field("mailboxName", mailboxRenamed.getNewPath().asString()).field("type", ADDED).log(logger -> logger.info("Mailbox renamed event"));
        }
        if (event instanceof MailboxEvents.MailboxDeletion) {
            MailboxEvents.MailboxDeletion mailboxDeletion = (MailboxEvents.MailboxDeletion)event;
            GhostMailbox.logger().field("mailboxId", mailboxDeletion.getMailboxId().serialize()).field("type", REMOVED).log(logger -> logger.info("Mailbox deleted event"));
        }
        if (event instanceof MailboxEvents.MailboxAdded) {
            MailboxEvents.MailboxAdded mailboxAdded = (MailboxEvents.MailboxAdded)event;
            GhostMailbox.logger().field("mailboxId", mailboxAdded.getMailboxId().serialize()).field("type", ADDED).log(logger -> logger.info("Mailbox added event"));
        }
    }

    public static class MailboxOperationLoggingListenerGroup
    extends Group {
    }
}

