/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.github.fge.lambdas.Throwing;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.ACLMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.cassandra.mail.task.MailboxMergingTask;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.store.StoreMessageIdManager;
import org.apache.james.task.Task;
import org.apache.james.util.streams.Limit;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MailboxMergingTaskRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxMergingTaskRunner.class);
    private final StoreMessageIdManager messageIdManager;
    private final CassandraMessageIdDAO cassandraMessageIdDAO;
    private final CassandraMailboxDAO mailboxDAO;
    private final ACLMapper aclMapper;
    private final MailboxSession mailboxSession;

    @Inject
    public MailboxMergingTaskRunner(MailboxManager mailboxManager, StoreMessageIdManager messageIdManager, CassandraMessageIdDAO cassandraMessageIdDAO, CassandraMailboxDAO mailboxDAO, ACLMapper aclMapper) {
        this.mailboxSession = mailboxManager.createSystemSession(Username.of((String)"task"));
        this.messageIdManager = messageIdManager;
        this.cassandraMessageIdDAO = cassandraMessageIdDAO;
        this.mailboxDAO = mailboxDAO;
        this.aclMapper = aclMapper;
    }

    public Task.Result run(CassandraId oldMailboxId, CassandraId newMailboxId, MailboxMergingTask.Context context) {
        return this.moveMessages(oldMailboxId, newMailboxId, this.mailboxSession, context).onComplete(new Task.Operation[]{() -> this.mergeRights(oldMailboxId, newMailboxId).block(), () -> this.mailboxDAO.delete(oldMailboxId).block()});
    }

    private Task.Result moveMessages(CassandraId oldMailboxId, CassandraId newMailboxId, MailboxSession session, MailboxMergingTask.Context context) {
        return (Task.Result)this.cassandraMessageIdDAO.retrieveMessages(oldMailboxId, MessageRange.all(), Limit.unlimited()).map(CassandraMessageMetadata::getComposedMessageId).map(ComposedMessageIdWithMetaData::getComposedMessageId).map(messageId -> this.moveMessage(newMailboxId, (ComposedMessageId)messageId, session, context)).reduce((Object)Task.Result.COMPLETED, Task::combine).block();
    }

    private Task.Result moveMessage(CassandraId newMailboxId, ComposedMessageId composedMessageId, MailboxSession session, MailboxMergingTask.Context context) {
        try {
            this.messageIdManager.setInMailboxesNoCheck(composedMessageId.getMessageId(), (MailboxId)newMailboxId, session);
            context.incrementMovedCount();
            return Task.Result.COMPLETED;
        }
        catch (MailboxException e) {
            LOGGER.warn("Failed moving message {}", (Object)composedMessageId.getMessageId(), (Object)e);
            context.incrementFailedCount();
            return Task.Result.PARTIAL;
        }
    }

    private Mono<Void> mergeRights(CassandraId oldMailboxId, CassandraId newMailboxId) {
        return Flux.concat((Publisher[])new Publisher[]{this.aclMapper.getACL(oldMailboxId), this.aclMapper.getACL(newMailboxId)}).reduce((BiFunction)Throwing.biFunction(MailboxACL::union)).flatMap(union -> this.aclMapper.setACL(newMailboxId, (MailboxACL)union)).then();
    }
}

