/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.util;

import com.google.common.collect.ImmutableList;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetAddress;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.redirect.RedirectNotify;
import org.apache.james.transport.mailets.redirect.SpecialAddress;
import org.apache.james.transport.util.SpecialAddressesUtils;
import org.apache.mailet.Mail;

public class TosUtils {
    private final RedirectNotify mailet;

    public static TosUtils from(RedirectNotify mailet) {
        return new TosUtils(mailet);
    }

    private TosUtils(RedirectNotify mailet) {
        this.mailet = mailet;
    }

    public List<MailAddress> getTo(Mail originalMail) throws MessagingException {
        List<InternetAddress> apparentlyTo = this.mailet.getTo();
        if (!apparentlyTo.isEmpty()) {
            if (this.containsOnlyUnalteredOrTo(apparentlyTo)) {
                return ImmutableList.of();
            }
            return SpecialAddressesUtils.from(this.mailet).replaceInternetAddresses(originalMail, apparentlyTo);
        }
        return ImmutableList.of();
    }

    private boolean containsOnlyUnalteredOrTo(List<InternetAddress> apparentlyTo) {
        return apparentlyTo.size() == 1 && (apparentlyTo.get(0).equals(SpecialAddress.UNALTERED.toInternetAddress().get()) || apparentlyTo.get(0).equals(SpecialAddress.RECIPIENTS.toInternetAddress().get()));
    }
}

