/*
 * Decompiled with CFR 0.152.
 */
package reactor.retry;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import reactor.retry.BackoffDelay;
import reactor.retry.Jitter;

class RandomJitter
implements Jitter {
    private final double randomFactor;

    public RandomJitter(double randomFactor) {
        if (randomFactor < 0.0 || randomFactor > 1.0) {
            throw new IllegalArgumentException("random factor must be between 0 and 1 (default 0.5)");
        }
        this.randomFactor = randomFactor;
    }

    @Override
    public Duration apply(BackoffDelay backoff) {
        if (backoff.delay.compareTo(backoff.min) < 0) {
            throw new IllegalArgumentException("jitter can only be applied on a delay that is >= to min backoff");
        }
        if (backoff.delay.compareTo(backoff.max) > 0) {
            throw new IllegalArgumentException("jitter can only be applied on a delay that is <= to max backoff");
        }
        if (backoff.delay.isZero()) {
            return backoff.delay;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long jitterOffset = this.jitterOffsetCapped(backoff);
        long lowBound = this.lowJitterBound(backoff, jitterOffset);
        long highBound = this.highJitterBound(backoff, jitterOffset);
        long jitter = highBound == lowBound ? (highBound == 0L ? 0L : random.nextLong(highBound)) : random.nextLong(lowBound, highBound);
        return backoff.delay.plusMillis(jitter);
    }

    long jitterOffsetCapped(BackoffDelay backoff) {
        try {
            return backoff.delay.multipliedBy((long)(100.0 * this.randomFactor)).dividedBy(100L).toMillis();
        }
        catch (ArithmeticException ae) {
            return Math.round(9.223372036854776E18 * this.randomFactor);
        }
    }

    long lowJitterBound(BackoffDelay backoff, long jitterOffset) {
        return Math.max(backoff.min.minus(backoff.delay).toMillis(), -jitterOffset);
    }

    long highJitterBound(BackoffDelay backoff, long jitterOffset) {
        return Math.min(backoff.max.minus(backoff.delay).toMillis(), jitterOffset);
    }

    public String toString() {
        return "Jitter{RANDOM-" + this.randomFactor + "}";
    }
}

