/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.User;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMoves;

public class MessageMoveEvent
implements Event {
    private final Event.EventId eventId;
    private final User user;
    private final MessageMoves messageMoves;
    private final Collection<MessageId> messageIds;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    MessageMoveEvent(Event.EventId eventId, User user, MessageMoves messageMoves, Collection<MessageId> messageIds) {
        this.eventId = eventId;
        this.user = user;
        this.messageMoves = messageMoves;
        this.messageIds = messageIds;
    }

    @Override
    public boolean isNoop() {
        return this.messageIds.isEmpty();
    }

    public Collection<MessageId> getMessageIds() {
        return this.messageIds;
    }

    @Override
    public Event.EventId getEventId() {
        return this.eventId;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    public MessageMoves getMessageMoves() {
        return this.messageMoves;
    }

    public boolean isMoveTo(MailboxId mailboxId) {
        return this.messageMoves.addedMailboxIds().contains(mailboxId);
    }

    public boolean isMoveFrom(MailboxId mailboxId) {
        return this.messageMoves.removedMailboxIds().contains(mailboxId);
    }

    public final boolean equals(Object o) {
        if (o instanceof MessageMoveEvent) {
            MessageMoveEvent that = (MessageMoveEvent)o;
            return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.user, that.user) && Objects.equals(this.messageMoves, that.messageMoves) && Objects.equals(this.messageIds, that.messageIds);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.eventId, this.user, this.messageMoves, this.messageIds);
    }

    public static class Builder {
        private ImmutableList.Builder<MessageId> messageIds = ImmutableList.builder();
        private User user;
        private MessageMoves messageMoves;
        private Optional<Event.EventId> eventId = Optional.empty();

        private Builder() {
        }

        public Builder session(MailboxSession session) {
            this.user = session.getUser();
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Builder messageMoves(MessageMoves messageMoves) {
            this.messageMoves = messageMoves;
            return this;
        }

        public Builder messageId(MessageId messageId) {
            this.messageIds.add((Object)messageId);
            return this;
        }

        public Builder eventId(Event.EventId eventId) {
            this.eventId = Optional.of(eventId);
            return this;
        }

        public Builder messageId(Iterable<MessageId> messageIds) {
            this.messageIds.addAll((Iterable)messageIds);
            return this;
        }

        public MessageMoveEvent build() {
            Preconditions.checkNotNull(this.user, "'user' is mandatory");
            Preconditions.checkNotNull(this.messageMoves, "'messageMoves' is mandatory");
            return new MessageMoveEvent(this.eventId.orElse(Event.EventId.random()), this.user, this.messageMoves, this.messageIds.build());
        }
    }
}

