/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.io.BinaryInputStream;
import org.apache.james.mime4j.io.TextInputStream;
import org.apache.james.mime4j.util.ByteArrayBuffer;

public final class InputStreams {
    private InputStreams() {
    }

    public static InputStream create(byte[] b, int off, int len) {
        if (b == null) {
            throw new IllegalArgumentException("Byte array may not be null");
        }
        return new BinaryInputStream(ByteBuffer.wrap(b, off, len));
    }

    public static InputStream create(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Byte array may not be null");
        }
        return new BinaryInputStream(ByteBuffer.wrap(b));
    }

    public static InputStream create(ByteArrayBuffer b) {
        if (b == null) {
            throw new IllegalArgumentException("Byte array may not be null");
        }
        return new BinaryInputStream(ByteBuffer.wrap(b.buffer(), 0, b.length()));
    }

    public static InputStream create(ByteBuffer b) {
        if (b == null) {
            throw new IllegalArgumentException("Byte array may not be null");
        }
        return new BinaryInputStream(b);
    }

    public static InputStream createAscii(CharSequence s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("CharSequence may not be null");
        }
        return new TextInputStream(s2, Charsets.US_ASCII, 1024);
    }

    public static InputStream create(CharSequence s2, Charset charset) {
        if (s2 == null) {
            throw new IllegalArgumentException("CharSequence may not be null");
        }
        return new TextInputStream(s2, charset != null ? charset : Charsets.DEFAULT_CHARSET, 1024);
    }
}

