/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InternalFluxOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.OptimizableOperator;
import reactor.core.scheduler.Scheduler;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class FluxRetryWhen<T>
extends InternalFluxOperator<T, T> {
    static final Duration MAX_BACKOFF = Duration.ofMillis(Long.MAX_VALUE);
    final Function<? super Flux<Throwable>, ? extends Publisher<?>> whenSourceFactory;

    FluxRetryWhen(Flux<? extends T> source, Function<? super Flux<Throwable>, ? extends Publisher<?>> whenSourceFactory) {
        super(source);
        this.whenSourceFactory = Objects.requireNonNull(whenSourceFactory, "whenSourceFactory");
    }

    static <T> void subscribe(CoreSubscriber<? super T> s2, Function<? super Flux<Throwable>, ? extends Publisher<?>> whenSourceFactory, CorePublisher<? extends T> source) {
        Publisher<?> p;
        RetryWhenOtherSubscriber other = new RetryWhenOtherSubscriber();
        CoreSubscriber<Throwable> signaller = Operators.serialize(other.completionSignal);
        signaller.onSubscribe(Operators.emptySubscription());
        CoreSubscriber<T> serial = Operators.serialize(s2);
        RetryWhenMainSubscriber<? extends T> main = new RetryWhenMainSubscriber<T>(serial, signaller, source);
        other.main = main;
        serial.onSubscribe(main);
        try {
            p = Objects.requireNonNull(whenSourceFactory.apply(other), "The whenSourceFactory returned a null Publisher");
        }
        catch (Throwable e) {
            s2.onError(Operators.onOperatorError(e, s2.currentContext()));
            return;
        }
        p.subscribe(other);
        if (!main.cancelled) {
            source.subscribe((CoreSubscriber<? extends T>)main);
        }
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        FluxRetryWhen.subscribe(actual, this.whenSourceFactory, this.source);
        return null;
    }

    static Function<Flux<Throwable>, Publisher<Long>> randomExponentialBackoffFunction(long numRetries, Duration firstBackoff, Duration maxBackoff, double jitterFactor, Scheduler backoffScheduler) {
        if (jitterFactor < 0.0 || jitterFactor > 1.0) {
            throw new IllegalArgumentException("jitterFactor must be between 0 and 1 (default 0.5)");
        }
        Objects.requireNonNull(firstBackoff, "firstBackoff is required");
        Objects.requireNonNull(maxBackoff, "maxBackoff is required");
        Objects.requireNonNull(backoffScheduler, "backoffScheduler is required");
        return t -> t.index().flatMap(t2 -> {
            long jitterOffset;
            Duration nextBackoff;
            long iteration = (Long)t2.getT1();
            if (iteration >= numRetries) {
                return Mono.error(new IllegalStateException("Retries exhausted: " + iteration + "/" + numRetries, (Throwable)t2.getT2()));
            }
            try {
                nextBackoff = firstBackoff.multipliedBy((long)Math.pow(2.0, iteration));
                if (nextBackoff.compareTo(maxBackoff) > 0) {
                    nextBackoff = maxBackoff;
                }
            }
            catch (ArithmeticException overflow) {
                nextBackoff = maxBackoff;
            }
            if (nextBackoff.isZero()) {
                return Mono.just(iteration);
            }
            ThreadLocalRandom random = ThreadLocalRandom.current();
            try {
                jitterOffset = nextBackoff.multipliedBy((long)(100.0 * jitterFactor)).dividedBy(100L).toMillis();
            }
            catch (ArithmeticException ae) {
                jitterOffset = Math.round(9.223372036854776E18 * jitterFactor);
            }
            long lowBound = Math.max(firstBackoff.minus(nextBackoff).toMillis(), -jitterOffset);
            long highBound = Math.min(maxBackoff.minus(nextBackoff).toMillis(), jitterOffset);
            long jitter = highBound == lowBound ? (highBound == 0L ? 0L : random.nextLong(highBound)) : random.nextLong(lowBound, highBound);
            Duration effectiveBackoff = nextBackoff.plusMillis(jitter);
            return Mono.delay(effectiveBackoff, backoffScheduler);
        });
    }

    static final class RetryWhenOtherSubscriber
    extends Flux<Throwable>
    implements InnerConsumer<Object>,
    OptimizableOperator<Throwable, Throwable> {
        RetryWhenMainSubscriber<?> main;
        final DirectProcessor<Throwable> completionSignal = new DirectProcessor();

        RetryWhenOtherSubscriber() {
        }

        @Override
        public Context currentContext() {
            return this.main.currentContext();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.main.otherArbiter;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.main;
            }
            return null;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.main.setWhen(s2);
        }

        @Override
        public void onNext(Object t) {
            this.main.resubscribe(t);
        }

        @Override
        public void onError(Throwable t) {
            this.main.whenError(t);
        }

        @Override
        public void onComplete() {
            this.main.whenComplete();
        }

        @Override
        public void subscribe(CoreSubscriber<? super Throwable> actual) {
            this.completionSignal.subscribe(actual);
        }

        @Override
        public CoreSubscriber<? super Throwable> subscribeOrReturn(CoreSubscriber<? super Throwable> actual) {
            return actual;
        }

        @Override
        public DirectProcessor<Throwable> source() {
            return this.completionSignal;
        }

        @Override
        public OptimizableOperator<?, ? extends Throwable> nextOptimizableSource() {
            return null;
        }
    }

    static final class RetryWhenMainSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Operators.DeferredSubscription otherArbiter;
        final Subscriber<Throwable> signaller;
        final CorePublisher<? extends T> source;
        Context context;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<RetryWhenMainSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(RetryWhenMainSubscriber.class, "wip");
        long produced;

        RetryWhenMainSubscriber(CoreSubscriber<? super T> actual, Subscriber<Throwable> signaller, CorePublisher<? extends T> source) {
            super(actual);
            this.signaller = signaller;
            this.source = source;
            this.otherArbiter = new Operators.DeferredSubscription();
            this.context = actual.currentContext();
        }

        @Override
        public Context currentContext() {
            return this.context;
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(Scannable.from(this.signaller), this.otherArbiter);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.otherArbiter.cancel();
                super.cancel();
            }
        }

        public void setWhen(Subscription w) {
            this.otherArbiter.set(w);
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
            ++this.produced;
        }

        @Override
        public void onError(Throwable t) {
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.otherArbiter.request(1L);
            this.signaller.onNext(t);
        }

        @Override
        public void onComplete() {
            this.otherArbiter.cancel();
            this.actual.onComplete();
        }

        void resubscribe(Object trigger) {
            if (WIP.getAndIncrement(this) == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    if (trigger instanceof Context) {
                        this.context = (Context)trigger;
                    }
                    this.source.subscribe(this);
                } while (WIP.decrementAndGet(this) != 0);
            }
        }

        void whenError(Throwable e) {
            super.cancel();
            this.actual.onError(e);
        }

        void whenComplete() {
            super.cancel();
            this.actual.onComplete();
        }
    }
}

