/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMessage
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMessage.class);
    private final Logger logger;
    private boolean passThrough = true;
    private boolean headers = true;
    private boolean body = true;
    private int bodyMax = 0;
    private String comment = null;

    public LogMessage(Logger logger) {
        this.logger = logger;
    }

    public LogMessage() {
        this(LOGGER);
    }

    public void init() {
        try {
            this.passThrough = this.getInitParameter("passThrough", true);
            this.headers = this.getInitParameter("headers", true);
            this.body = this.getInitParameter("body", true);
            this.bodyMax = this.getInitParameter("maxBody") == null ? 0 : Integer.parseInt(this.getInitParameter("maxBody"));
            this.comment = this.getInitParameter("comment");
        }
        catch (Exception e) {
            this.logger.error("Caught exception while initializing LogMessage", (Throwable)e);
        }
    }

    public String getMailetInfo() {
        return "LogHeaders Mailet";
    }

    public void service(Mail mail) {
        this.logger.info("Logging mail {}", (Object)mail.getName());
        this.logComment();
        try {
            MimeMessage message = mail.getMessage();
            this.logHeaders(message);
            this.logBody(message);
        }
        catch (IOException | MessagingException e) {
            this.logger.error("Error logging message.", e);
        }
        if (!this.passThrough) {
            mail.setState("ghost");
        }
    }

    private void logComment() {
        if (this.comment != null) {
            this.logger.info(this.comment);
        }
    }

    private void logHeaders(MimeMessage message) throws MessagingException {
        if (this.headers && this.logger.isInfoEnabled()) {
            this.logger.info("\n");
            for (String header : Collections.list(message.getAllHeaderLines())) {
                this.logger.info(header + "\n");
            }
        }
    }

    private void logBody(MimeMessage message) throws MessagingException, IOException {
        if (this.body && this.logger.isInfoEnabled()) {
            try (InputStream inputStream = ByteStreams.limit((InputStream)message.getDataHandler().getInputStream(), (long)this.lengthToLog(message));){
                this.logger.info(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
        }
    }

    private int lengthToLog(MimeMessage message) throws MessagingException {
        return this.bodyMax > 0 ? this.bodyMax : this.messageSizeOrUnlimited(message);
    }

    private int messageSizeOrUnlimited(MimeMessage message) throws MessagingException {
        int computedSize = message.getSize();
        if (computedSize > 0) {
            return computedSize;
        }
        return Integer.MAX_VALUE;
    }
}

