/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.CassandraZonedDateTimeModule;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.server.task.json.JsonTaskAdditionalInformationSerializer;
import org.apache.james.task.Hostname;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskType;
import org.apache.james.task.eventsourcing.cassandra.CassandraTaskExecutionDetailsProjectionTable$;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001B\u000e\u001d\u0001%B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A1\n\u0001B\u0001B\u0003%A\nC\u0003V\u0001\u0011\u0005a\u000bC\u0004f\u0001\t\u0007I\u0011\u00024\t\r5\u0004\u0001\u0015!\u0003h\u0011\u001dq\u0007A1A\u0005\n=DaA\u001e\u0001!\u0002\u0013\u0001\bbB<\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011B=\t\u0011\u0005\u0005\u0001A1A\u0005\naDq!a\u0001\u0001A\u0003%\u0011\u0010\u0003\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003y\u0011\u001d\t9\u0001\u0001Q\u0001\neD\u0001\"!\u0003\u0001\u0005\u0004%I\u0001\u001f\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003z\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!a\u0010\u0001\t\u0013\t\t\u0005C\u0004\u0002x\u0001!I!!\u001f\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAY\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003w\u0003A\u0011AA_\u0011\u001d\ty\r\u0001C\u0001\u0003#Dq!!6\u0001\t\u0013\t9\u000eC\u0004\u0002d\u0002!I!!:\u0003U\r\u000b7o]1oIJ\fG+Y:l\u000bb,7-\u001e;j_:$U\r^1jYN\u0004&o\u001c6fGRLwN\u001c#B\u001f*\u0011QDH\u0001\nG\u0006\u001c8/\u00198ee\u0006T!a\b\u0011\u0002\u001b\u00154XM\u001c;t_V\u00148-\u001b8h\u0015\t\t#%\u0001\u0003uCN\\'BA\u0012%\u0003\u0015Q\u0017-\\3t\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0002\u000fM,7o]5p]B\u0011!gP\u0007\u0002g)\u0011A'N\u0001\u0005G>\u0014XM\u0003\u00027o\u0005\u0019\u0011\r]5\u000b\u0005aJ\u0014A\u00023sSZ,'O\u0003\u0002;w\u0005\u0019qn]:\u000b\u0005qj\u0014\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003y\n1aY8n\u0013\t\u00015G\u0001\u0006Dc2\u001cVm]:j_:\fQ\u0002^=qKN\u0004&o\u001c<jI\u0016\u0014\bCA\"J\u001b\u0005!%BA#G\u0003\u0011Ig.\u001b;\u000b\u0005u9%B\u0001%#\u0003!\u0011\u0017mY6f]\u0012\u001c\u0018B\u0001&E\u0005Y\u0019\u0015m]:b]\u0012\u0014\u0018\rV=qKN\u0004&o\u001c<jI\u0016\u0014\u0018a\n6t_:$\u0016m]6BI\u0012LG/[8oC2LeNZ8s[\u0006$\u0018n\u001c8TKJL\u0017\r\\5{KJ\u0004\"!T*\u000e\u00039S!a\u0014)\u0002\t)\u001cxN\u001c\u0006\u0003CES!A\u0015\u0012\u0002\rM,'O^3s\u0013\t!fJA\u0014Kg>tG+Y:l\u0003\u0012$\u0017\u000e^5p]\u0006d\u0017J\u001c4pe6\fG/[8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003X3j[\u0006C\u0001-\u0001\u001b\u0005a\u0002\"\u0002\u0019\u0005\u0001\u0004\t\u0004\"B!\u0005\u0001\u0004\u0011\u0005\"B&\u0005\u0001\u0004a\u0005F\u0001\u0003^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0004j]*,7\r\u001e\u0006\u0002E\u0006)!.\u0019<bq&\u0011Am\u0018\u0002\u0007\u0013:TWm\u0019;\u0002-\r\f7o]1oIJ\f\u0017i]=oG\u0016CXmY;u_J,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u001a\u000bQ!\u001e;jYNL!\u0001\\5\u0003-\r\u000b7o]1oIJ\f\u0017i]=oG\u0016CXmY;u_J\fqcY1tg\u0006tGM]1Bgft7-\u0012=fGV$xN\u001d\u0011\u0002\u0011\u0011\fG/\u001a+za\u0016,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003gN\nA\u0001^=qK&\u0011QO\u001d\u0002\u0010+N,'\u000fR3gS:,G\rV=qK\u0006IA-\u0019;f)f\u0004X\rI\u0001\u0010S:\u001cXM\u001d;Ti\u0006$X-\\3oiV\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}g\u0005\u00191-\u001d7\n\u0005y\\(!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\u0006\u0001\u0012N\\:feR\u001cF/\u0019;f[\u0016tG\u000fI\u0001\u0010g\u0016dWm\u0019;Ti\u0006$X-\\3oi\u0006\u00012/\u001a7fGR\u001cF/\u0019;f[\u0016tG\u000fI\u0001\u000eY&\u001cHo\u0015;bi\u0016lWM\u001c;\u0002\u001d1L7\u000f^*uCR,W.\u001a8uA\u0005y!/Z7pm\u0016\u001cF/\u0019;f[\u0016tG/\u0001\tsK6|g/Z*uCR,W.\u001a8uA\u0005Y1/\u0019<f\t\u0016$\u0018-\u001b7t)\u0011\t\t\"a\r\u0011\r\u0005M\u0011qDA\u0012\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!\u00039vE2L7\u000f[3s\u0015\r!\u00141\u0004\u0006\u0003\u0003;\tqA]3bGR|'/\u0003\u0003\u0002\"\u0005U!\u0001B'p]>\u0004B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0003mC:<'BAA\u0017\u0003\u0011Q\u0017M^1\n\t\u0005E\u0012q\u0005\u0002\u0005->LG\rC\u0004\u00026E\u0001\r!a\u000e\u0002\u000f\u0011,G/Y5mgB!\u0011\u0011HA\u001e\u001b\u0005\u0001\u0013bAA\u001fA\t!B+Y:l\u000bb,7-\u001e;j_:$U\r^1jYN\fqCY5oI>\u0003H/[8oC2\u001cFO]5oOZ\u000bG.^3\u0015\u0011\u0005\r\u0013\u0011JA'\u0003O\u00022A_A#\u0013\r\t9e\u001f\u0002\u000f\u0005>,h\u000eZ*uCR,W.\u001a8u\u0011\u001d\tYE\u0005a\u0001\u0003\u0007\n\u0011b\u001d;bi\u0016lWM\u001c;\t\u000f\u0005=#\u00031\u0001\u0002R\u0005Ia-[3mI:\u000bW.\u001a\t\u0005\u0003'\n\tG\u0004\u0003\u0002V\u0005u\u0003cAA,Y5\u0011\u0011\u0011\f\u0006\u0004\u00037B\u0013A\u0002\u001fs_>$h(C\u0002\u0002`1\na\u0001\u0015:fI\u00164\u0017\u0002BA2\u0003K\u0012aa\u0015;sS:<'bAA0Y!9\u0011\u0011\u000e\nA\u0002\u0005-\u0014A\u00034jK2$g+\u00197vKB1\u0011QNA:\u0003#j!!a\u001c\u000b\t\u0005E\u00141F\u0001\u0005kRLG.\u0003\u0003\u0002v\u0005=$\u0001C(qi&|g.\u00197\u0002)\tLg\u000eZ(qi&|g.\u00197V\tR3\u0016\r\\;f)!\t\u0019%a\u001f\u0002~\u0005}\u0004bBA&'\u0001\u0007\u00111\t\u0005\b\u0003\u001f\u001a\u0002\u0019AA)\u0011\u001d\tIg\u0005a\u0001\u0003\u0003\u0003b!!\u001c\u0002t\u0005\r\u0005\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%5'\u0001\u0003eCR\f\u0017\u0002BAG\u0003\u000f\u0013\u0001\"\u00163u-\u0006dW/Z\u0001\u001fg\u0016\u0014\u0018.\u00197ju\u0016\fE\rZ5uS>t\u0017\r\\%oM>\u0014X.\u0019;j_:$B!a%\u0002 B1\u0011QSAN\u0003Wj!!a&\u000b\t\u0005]\u0011\u0011\u0014\u0006\u0004[\u0005e\u0011\u0002BAO\u0003/\u0013QaU'p]>Dq!!\u000e\u0015\u0001\u0004\t9$A\u0006sK\u0006$G)\u001a;bS2\u001cH\u0003BAS\u0003O\u0003b!a\u0005\u0002 \u0005]\u0002bBAU+\u0001\u0007\u00111V\u0001\u0007i\u0006\u001c8.\u00133\u0011\t\u0005e\u0012QV\u0005\u0004\u0003_\u0003#A\u0002+bg.LE-A\u0006mSN$H)\u001a;bS2\u001cHCAA[!\u0019\t\u0019\"a.\u00028%!\u0011\u0011XA\u000b\u0005\u00111E.\u001e=\u0002/1L7\u000f\u001e#fi\u0006LGn\u001d\"z\u0005\u00164wN]3ECR,G\u0003BA[\u0003\u007fCq!!1\u0018\u0001\u0004\t\u0019-\u0001\u0006cK\u001a|'/\u001a#bi\u0016\u0004B!!2\u0002L6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY#\u0001\u0003uS6,\u0017\u0002BAg\u0003\u000f\u0014q!\u00138ti\u0006tG/\u0001\u0004sK6|g/\u001a\u000b\u0005\u0003#\t\u0019\u000eC\u0004\u00026a\u0001\r!a\u000e\u0002\u000fI,\u0017\r\u001a*poR!\u0011qGAm\u0011\u001d\tY.\u0007a\u0001\u0003;\f1A]8x!\rQ\u0018q\\\u0005\u0004\u0003C\\(a\u0001*po\u0006\u0001C-Z:fe&\fG.\u001b>f\u0003\u0012$\u0017\u000e^5p]\u0006d\u0017J\u001c4pe6\fG/[8o)\u0019\t9/a>\u0003\u0002A1\u0011QNA:\u0003S\u0004B!a;\u0002r:!\u0011\u0011HAw\u0013\r\ty\u000fI\u0001\u0015)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8EKR\f\u0017\u000e\\:\n\t\u0005M\u0018Q\u001f\u0002\u0016\u0003\u0012$\u0017\u000e^5p]\u0006d\u0017J\u001c4pe6\fG/[8o\u0015\r\ty\u000f\t\u0005\b\u0003sT\u0002\u0019AA~\u0003!!\u0018m]6UsB,\u0007\u0003BA\u001d\u0003{L1!a@!\u0005!!\u0016m]6UsB,\u0007bBAn5\u0001\u0007\u0011Q\u001c")
public class CassandraTaskExecutionDetailsProjectionDAO {
    private final JsonTaskAdditionalInformationSerializer jsonTaskAdditionalInformationSerializer;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final UserDefinedType dateType;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectStatement;
    private final PreparedStatement listStatement;
    private final PreparedStatement removeStatement;

    private CassandraAsyncExecutor cassandraAsyncExecutor() {
        return this.cassandraAsyncExecutor;
    }

    private UserDefinedType dateType() {
        return this.dateType;
    }

    private PreparedStatement insertStatement() {
        return this.insertStatement;
    }

    private PreparedStatement selectStatement() {
        return this.selectStatement;
    }

    private PreparedStatement listStatement() {
        return this.listStatement;
    }

    private PreparedStatement removeStatement() {
        return this.removeStatement;
    }

    public Mono<Void> saveDetails(TaskExecutionDetails details) {
        return Mono.from((Publisher)this.serializeAdditionalInformation(details).flatMap((Function1 & Serializable)serializeAdditionalInformation -> {
            BoundStatement boundStatement = (BoundStatement)this.insertStatement().bind(new Object[0]).setUuid(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), details.getTaskId().getValue()).setString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE(), details.getType().asString()).setString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS(), details.getStatus().getValue()).setUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE(), CassandraZonedDateTimeModule.toUDT((UserDefinedType)this.dateType(), (ZonedDateTime)details.getSubmittedDate())).setString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE(), details.getSubmittedNode().asString());
            .colon.colon bindOptionalFieldOperations = new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE(), CassandraZonedDateTimeModule.toUDT((UserDefinedType)this.dateType(), (Optional)details.getStartedDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalStringValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE(), details.getRanNode().map(x$1 -> x$1.asString())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE(), CassandraZonedDateTimeModule.toUDT((UserDefinedType)this.dateType(), (Optional)details.getCompletedDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE(), CassandraZonedDateTimeModule.toUDT((UserDefinedType)this.dateType(), (Optional)details.getCanceledDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalStringValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE(), details.getCancelRequestedNode().map(x$2 -> x$2.asString())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE(), CassandraZonedDateTimeModule.toUDT((UserDefinedType)this.dateType(), (Optional)details.getFailedDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalStringValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION(), (Optional<String>)serializeAdditionalInformation), (List)Nil$.MODULE$)))))));
            BoundStatement fullyBoundStatement = (BoundStatement)bindOptionalFieldOperations.foldLeft((Object)boundStatement, (Function2 & Serializable)(statement, bindFieldOperation) -> (BoundStatement)bindFieldOperation.apply(statement));
            return SMono$.MODULE$.apply((Publisher)this.cassandraAsyncExecutor().executeVoid((Statement)fullyBoundStatement));
        }));
    }

    private BoundStatement bindOptionalStringValue(BoundStatement statement, String fieldName, Optional<String> fieldValue) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(fieldValue));
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            return (BoundStatement)statement.setString(fieldName, value);
        }
        if (None$.MODULE$.equals(option)) {
            return statement;
        }
        throw new MatchError((Object)option);
    }

    private BoundStatement bindOptionalUDTValue(BoundStatement statement, String fieldName, Optional<UdtValue> fieldValue) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(fieldValue));
        if (option instanceof Some) {
            Some some = (Some)option;
            UdtValue value = (UdtValue)some.value();
            return (BoundStatement)statement.setUdtValue(fieldName, value);
        }
        if (None$.MODULE$.equals(option)) {
            return statement;
        }
        throw new MatchError((Object)option);
    }

    private SMono<Optional<String>> serializeAdditionalInformation(TaskExecutionDetails details) {
        return SMono$.MODULE$.fromCallable(() -> details.getAdditionalInformation().map(x$3 -> $this.jsonTaskAdditionalInformationSerializer.serialize(x$3))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    public Mono<TaskExecutionDetails> readDetails(TaskId taskId) {
        return this.cassandraAsyncExecutor().executeSingleRow((Statement)this.selectStatement().bind(new Object[0]).setUuid(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), taskId.getValue())).map(row -> this.readRow((Row)row));
    }

    public Flux<TaskExecutionDetails> listDetails() {
        return this.cassandraAsyncExecutor().executeRows((Statement)this.listStatement().bind(new Object[0])).map(row -> this.readRow((Row)row));
    }

    public Flux<TaskExecutionDetails> listDetailsByBeforeDate(Instant beforeDate) {
        return this.listDetails().filter(detail -> detail.getSubmittedDate().toInstant().isBefore(beforeDate));
    }

    public Mono<Void> remove(TaskExecutionDetails details) {
        return this.cassandraAsyncExecutor().executeVoid((Statement)this.removeStatement().bind(new Object[0]).setUuid(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), details.getTaskId().getValue()));
    }

    private TaskExecutionDetails readRow(Row row) {
        TaskType taskType = TaskType.of((String)row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE()));
        TaskId x$1 = TaskId.fromUUID((UUID)row.getUuid(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()));
        TaskType x$2 = TaskType.of((String)row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE()));
        TaskManager.Status x$3 = TaskManager.Status.fromString((String)row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS()));
        ZonedDateTime x$42 = CassandraZonedDateTimeModule.fromUDT((UdtValue)row.getUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE()));
        Hostname x$52 = new Hostname(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE()));
        Optional x$6 = CassandraZonedDateTimeModule.fromUDTOptional((UdtValue)row.getUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE()));
        Optional<Hostname> x$7 = Optional.ofNullable(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE())).map(x$4 -> new Hostname(x$4));
        Optional x$8 = CassandraZonedDateTimeModule.fromUDTOptional((UdtValue)row.getUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE()));
        Optional x$9 = CassandraZonedDateTimeModule.fromUDTOptional((UdtValue)row.getUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE()));
        Optional<Hostname> x$10 = Optional.ofNullable(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE())).map(x$5 -> new Hostname(x$5));
        Optional x$11 = CassandraZonedDateTimeModule.fromUDTOptional((UdtValue)row.getUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE()));
        Function0 & Serializable x$12 = (Function0 & Serializable)() -> this.deserializeAdditionalInformation(taskType, row);
        return new TaskExecutionDetails(x$1, x$2, x$3, x$42, x$52, (Function0)x$12, x$6, x$7, x$8, x$9, x$10, x$11);
    }

    private Optional<TaskExecutionDetails.AdditionalInformation> deserializeAdditionalInformation(TaskType taskType, Row row) {
        return Optional.ofNullable(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION())).map(additionalInformation -> $this.jsonTaskAdditionalInformationSerializer.deserialize(additionalInformation));
    }

    @Inject
    public CassandraTaskExecutionDetailsProjectionDAO(CqlSession session, CassandraTypesProvider typesProvider, JsonTaskAdditionalInformationSerializer jsonTaskAdditionalInformationSerializer) {
        this.jsonTaskAdditionalInformationSerializer = jsonTaskAdditionalInformationSerializer;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.dateType = typesProvider.getDefinedUserType("zonedDateTime");
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TABLE_NAME()).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION())).build());
        this.selectStatement = session.prepare(((BuildableQuery)QueryBuilder.selectFrom((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TABLE_NAME()).all().whereColumn(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()).isEqualTo((Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()))).build());
        this.listStatement = session.prepare(QueryBuilder.selectFrom((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TABLE_NAME()).all().build());
        this.removeStatement = session.prepare(((BuildableQuery)QueryBuilder.deleteFrom((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TABLE_NAME()).whereColumn(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()).isEqualTo((Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()))).build());
    }
}

