/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.collection;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CompositeQueryPlan
extends AbstractQueue<Node>
implements QueryPlan {
    private final Queue<Node>[] plans;
    private final AtomicInteger currentPlan = new AtomicInteger(0);

    @SafeVarargs
    public CompositeQueryPlan(Queue<Node> ... plans) {
        if (plans.length == 0) {
            throw new IllegalArgumentException("at least one child plan must be provided");
        }
        for (Queue<Node> plan : plans) {
            if (plan != null) continue;
            throw new NullPointerException("child plan cannot be null");
        }
        this.plans = plans;
    }

    @Override
    @Nullable
    public Node poll() {
        int current;
        Queue<Node> plan;
        Node n;
        while ((n = (plan = this.plans[current = this.currentPlan.get()]).poll()) == null) {
            int next = current + 1;
            if (next == this.plans.length) {
                return null;
            }
            this.currentPlan.compareAndSet(current, next);
        }
        return n;
    }

    @Override
    @NonNull
    public Iterator<Node> iterator() {
        ArrayList its = new ArrayList(this.plans.length);
        for (Queue<Node> plan : this.plans) {
            its.add(plan.iterator());
        }
        return Iterators.concat(its.iterator());
    }

    @Override
    public int size() {
        int size = 0;
        for (Queue<Node> plan : this.plans) {
            size += plan.size();
        }
        return size;
    }
}

