/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.DenseVectorIndexOptions;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyBase;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class DenseVectorProperty
extends PropertyBase
implements PropertyVariant {
    private final int dims;
    @Nullable
    private final String similarity;
    @Nullable
    private final Boolean index;
    @Nullable
    private final DenseVectorIndexOptions indexOptions;
    public static final JsonpDeserializer<DenseVectorProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DenseVectorProperty::setupDenseVectorPropertyDeserializer);

    private DenseVectorProperty(Builder builder) {
        super(builder);
        this.dims = ApiTypeHelper.requireNonNull(builder.dims, this, "dims");
        this.similarity = builder.similarity;
        this.index = builder.index;
        this.indexOptions = builder.indexOptions;
    }

    public static DenseVectorProperty of(Function<Builder, ObjectBuilder<DenseVectorProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.DenseVector;
    }

    public final int dims() {
        return this.dims;
    }

    @Nullable
    public final String similarity() {
        return this.similarity;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final DenseVectorIndexOptions indexOptions() {
        return this.indexOptions;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "dense_vector");
        super.serializeInternal(generator, mapper);
        generator.writeKey("dims");
        generator.write(this.dims);
        if (this.similarity != null) {
            generator.writeKey("similarity");
            generator.write(this.similarity);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.indexOptions != null) {
            generator.writeKey("index_options");
            this.indexOptions.serialize(generator, mapper);
        }
    }

    protected static void setupDenseVectorPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::dims, JsonpDeserializer.integerDeserializer(), "dims");
        op.add(Builder::similarity, JsonpDeserializer.stringDeserializer(), "similarity");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::indexOptions, DenseVectorIndexOptions._DESERIALIZER, "index_options");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DenseVectorProperty> {
        private Integer dims;
        @Nullable
        private String similarity;
        @Nullable
        private Boolean index;
        @Nullable
        private DenseVectorIndexOptions indexOptions;

        public final Builder dims(int value) {
            this.dims = value;
            return this;
        }

        public final Builder similarity(@Nullable String value) {
            this.similarity = value;
            return this;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder indexOptions(@Nullable DenseVectorIndexOptions value) {
            this.indexOptions = value;
            return this;
        }

        public final Builder indexOptions(Function<DenseVectorIndexOptions.Builder, ObjectBuilder<DenseVectorIndexOptions>> fn) {
            return this.indexOptions(fn.apply(new DenseVectorIndexOptions.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DenseVectorProperty build() {
            this._checkSingleUse();
            return new DenseVectorProperty(this);
        }
    }
}

