/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.util.collection.CharObjectHashMap;
import io.netty.util.collection.CharObjectMap;
import io.r2dbc.postgresql.ParsedSql;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class PostgresqlSqlParser {
    private static final CharObjectMap<Object> SPECIAL_AND_OPERATOR_CHARS;

    PostgresqlSqlParser() {
    }

    public static ParsedSql parse(String sql) {
        List<ParsedSql.Token> tokens = PostgresqlSqlParser.tokenize(sql);
        ArrayList<ParsedSql.Statement> statements = new ArrayList<ParsedSql.Statement>();
        LinkedList<Boolean> functionBodyList = null;
        ArrayList<ParsedSql.Token> currentStatementTokens = new ArrayList<ParsedSql.Token>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            ParsedSql.Token current = tokens.get(i);
            currentStatementTokens.add(current);
            if (current.getType() == ParsedSql.TokenType.DEFAULT) {
                String currentValue = current.getValue();
                if (currentValue.equalsIgnoreCase("BEGIN")) {
                    if (functionBodyList == null) {
                        functionBodyList = new LinkedList<Boolean>();
                    }
                    if (PostgresqlSqlParser.hasNextToken(tokens, i) && PostgresqlSqlParser.peekNext(tokens, i).getValue().equalsIgnoreCase("ATOMIC")) {
                        functionBodyList.add(true);
                        continue;
                    }
                    functionBodyList.add(false);
                    continue;
                }
                if (!currentValue.equalsIgnoreCase("END") || functionBodyList == null || functionBodyList.isEmpty()) continue;
                functionBodyList.removeLast();
                continue;
            }
            if (!current.getType().equals((Object)ParsedSql.TokenType.STATEMENT_END)) continue;
            boolean inFunctionBody = false;
            if (functionBodyList != null) {
                Iterator iterator = functionBodyList.iterator();
                while (iterator.hasNext()) {
                    boolean b = (Boolean)iterator.next();
                    inFunctionBody |= b;
                }
            }
            if (inFunctionBody) continue;
            statements.add(new ParsedSql.Statement(currentStatementTokens));
            currentStatementTokens = new ArrayList();
        }
        if (!currentStatementTokens.isEmpty()) {
            statements.add(new ParsedSql.Statement(currentStatementTokens));
        }
        return new ParsedSql(sql, statements);
    }

    private static ParsedSql.Token peekNext(List<ParsedSql.Token> tokens, int index) {
        return tokens.get(index + 1);
    }

    private static boolean hasNextToken(List<ParsedSql.Token> tokens, int index) {
        return tokens.size() > index + 1;
    }

    private static char peekNext(CharSequence sequence, int index) {
        return sequence.charAt(index + 1);
    }

    private static boolean hasNextToken(CharSequence sequence, int index) {
        return sequence.length() > index + 1;
    }

    private static List<ParsedSql.Token> tokenize(String sql) {
        ArrayList<ParsedSql.Token> tokens = new ArrayList<ParsedSql.Token>();
        int i = 0;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            ParsedSql.Token token = null;
            if (Character.isWhitespace(c)) {
                ++i;
                continue;
            }
            switch (c) {
                case '\'': {
                    token = PostgresqlSqlParser.getStandardQuoteToken(sql, i);
                    break;
                }
                case '\"': {
                    token = PostgresqlSqlParser.getQuotedIdentifierToken(sql, i);
                    break;
                }
                case '-': {
                    if (!PostgresqlSqlParser.hasNextToken(sql, i) || PostgresqlSqlParser.peekNext(sql, i) != '-') break;
                    token = PostgresqlSqlParser.getCommentToLineEndToken(sql, i);
                    break;
                }
                case '/': {
                    if (!PostgresqlSqlParser.hasNextToken(sql, i) || PostgresqlSqlParser.peekNext(sql, i) != '*') break;
                    token = PostgresqlSqlParser.getBlockCommentToken(sql, i);
                    break;
                }
                case '$': {
                    token = PostgresqlSqlParser.getParameterOrDollarQuoteToken(sql, i);
                    break;
                }
                case ';': {
                    token = new ParsedSql.Token(ParsedSql.TokenType.STATEMENT_END, ";");
                    break;
                }
            }
            if (token == null) {
                token = PostgresqlSqlParser.isSpecialOrOperatorChar(c) ? new ParsedSql.Token(ParsedSql.TokenType.SPECIAL_OR_OPERATOR, Character.toString(c)) : PostgresqlSqlParser.getDefaultToken(sql, i);
            }
            i += token.getValue().length();
            tokens.add(token);
        }
        return tokens;
    }

    private static ParsedSql.Token getDefaultToken(String sql, int beginIndex) {
        for (int i = beginIndex + 1; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (!Character.isWhitespace(c) && !PostgresqlSqlParser.isSpecialOrOperatorChar(c)) continue;
            return new ParsedSql.Token(ParsedSql.TokenType.DEFAULT, sql.substring(beginIndex, i));
        }
        return new ParsedSql.Token(ParsedSql.TokenType.DEFAULT, sql.substring(beginIndex));
    }

    private static boolean isSpecialOrOperatorChar(char c) {
        return SPECIAL_AND_OPERATOR_CHARS.containsKey(c);
    }

    private static ParsedSql.Token getBlockCommentToken(String sql, int beginIndex) {
        int depth = 1;
        for (int i = beginIndex + 2; i < sql.length() - 1; ++i) {
            char c1 = sql.charAt(i);
            char c2 = sql.charAt(i + 1);
            if (c1 == '/' && c2 == '*') {
                ++depth;
                ++i;
            } else if (c1 == '*' && c2 == '/') {
                --depth;
                ++i;
            }
            if (depth != 0) continue;
            return new ParsedSql.Token(ParsedSql.TokenType.COMMENT, sql.substring(beginIndex, i + 1));
        }
        throw new IllegalArgumentException("Sql cannot be parsed: unclosed block comment (comment opened at index " + beginIndex + ") in statement: " + sql);
    }

    private static ParsedSql.Token getCommentToLineEndToken(String sql, int beginIndex) {
        int lineEnding = sql.indexOf(10, beginIndex);
        if (lineEnding == -1) {
            return new ParsedSql.Token(ParsedSql.TokenType.COMMENT, sql.substring(beginIndex));
        }
        return new ParsedSql.Token(ParsedSql.TokenType.COMMENT, sql.substring(beginIndex, lineEnding));
    }

    private static ParsedSql.Token getDollarQuoteToken(String sql, String tag, int beginIndex) {
        int nextQuote = sql.indexOf(tag, beginIndex + tag.length());
        if (nextQuote == -1) {
            throw new IllegalArgumentException("Sql cannot be parsed: unclosed quote (quote opened at index " + beginIndex + ") in statement: " + sql);
        }
        return new ParsedSql.Token(ParsedSql.TokenType.STRING_CONSTANT, sql.substring(beginIndex, nextQuote + tag.length()));
    }

    private static ParsedSql.Token getParameterToken(String sql, int beginIndex) {
        for (int i = beginIndex + 1; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (Character.isWhitespace(c) || PostgresqlSqlParser.isSpecialOrOperatorChar(c)) {
                return new ParsedSql.Token(ParsedSql.TokenType.PARAMETER, sql.substring(beginIndex, i));
            }
            if (PostgresqlSqlParser.isAsciiDigit(c)) continue;
            throw new IllegalArgumentException("Sql cannot be parsed: illegal character in parameter or dollar-quote tag: " + c);
        }
        return new ParsedSql.Token(ParsedSql.TokenType.PARAMETER, sql.substring(beginIndex));
    }

    private static ParsedSql.Token getParameterOrDollarQuoteToken(String sql, int beginIndex) {
        char firstChar = sql.charAt(beginIndex + 1);
        if (firstChar == '$') {
            return PostgresqlSqlParser.getDollarQuoteToken(sql, "$$", beginIndex);
        }
        if (PostgresqlSqlParser.isAsciiDigit(firstChar)) {
            return PostgresqlSqlParser.getParameterToken(sql, beginIndex);
        }
        for (int i = beginIndex + 1; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '$') {
                return PostgresqlSqlParser.getDollarQuoteToken(sql, sql.substring(beginIndex, i + 1), beginIndex);
            }
            if (PostgresqlSqlParser.isAsciiLetter(c) || c == '_' || PostgresqlSqlParser.isAsciiDigit(c)) continue;
            throw new IllegalArgumentException("Sql cannot be parsed: illegal character in dollar-quote tag (quote opened at index " + beginIndex + ") in statement: " + sql);
        }
        throw new IllegalArgumentException("Sql cannot be parsed: unclosed dollar-quote tag(quote opened at index " + beginIndex + ") in statement: " + sql);
    }

    private static ParsedSql.Token getStandardQuoteToken(String sql, int beginIndex) {
        int nextQuote = sql.indexOf(39, beginIndex + 1);
        if (nextQuote == -1) {
            throw new IllegalArgumentException("Sql cannot be parsed: unclosed quote (quote opened at index " + beginIndex + ") in statement: " + sql);
        }
        return new ParsedSql.Token(ParsedSql.TokenType.STRING_CONSTANT, sql.substring(beginIndex, nextQuote + 1));
    }

    private static ParsedSql.Token getQuotedIdentifierToken(String sql, int beginIndex) {
        int nextQuote = sql.indexOf(34, beginIndex + 1);
        if (nextQuote == -1) {
            throw new IllegalArgumentException("Sql cannot be parsed: unclosed quoted identifier (identifier opened at index " + beginIndex + ") in statement: " + sql);
        }
        return new ParsedSql.Token(ParsedSql.TokenType.QUOTED_IDENTIFIER, sql.substring(beginIndex, nextQuote + 1));
    }

    private static boolean isAsciiLetter(char c) {
        char lower = Character.toLowerCase(c);
        return lower >= 'a' && lower <= 'z';
    }

    private static boolean isAsciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static {
        char[] specialCharsAndOperators;
        SPECIAL_AND_OPERATOR_CHARS = new CharObjectHashMap();
        for (char c : specialCharsAndOperators = new char[]{'+', '-', '*', '/', '<', '>', '=', '~', '!', '@', '#', '%', '^', '&', '|', '`', '?', '(', ')', '[', ']', ',', ';', ':', '*', '.', '\'', '\"'}) {
            SPECIAL_AND_OPERATOR_CHARS.put(c, new Object());
        }
    }
}

