/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.NormalizeMethod;
import org.opensearch.client.opensearch._types.aggregations.PipelineAggregationBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class NormalizeAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final NormalizeMethod method;
    public static final JsonpDeserializer<NormalizeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NormalizeAggregation::setupNormalizeAggregationDeserializer);

    private NormalizeAggregation(Builder builder) {
        super(builder);
        this.method = builder.method;
    }

    public static NormalizeAggregation of(Function<Builder, ObjectBuilder<NormalizeAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Normalize;
    }

    @Nullable
    public final NormalizeMethod method() {
        return this.method;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.method != null) {
            generator.writeKey("method");
            this.method.serialize(generator, mapper);
        }
    }

    protected static void setupNormalizeAggregationDeserializer(ObjectDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::method, NormalizeMethod._DESERIALIZER, "method");
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NormalizeAggregation> {
        @Nullable
        private NormalizeMethod method;

        public final Builder method(@Nullable NormalizeMethod value) {
            this.method = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NormalizeAggregation build() {
            this._checkSingleUse();
            return new NormalizeAggregation(this);
        }
    }
}

