/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.FetchProfileBreakdown;
import org.opensearch.client.opensearch.core.search.FetchProfileDebug;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class FetchProfile
implements PlainJsonSerializable {
    private final String type;
    private final String description;
    private final long timeInNanos;
    private final FetchProfileBreakdown breakdown;
    @Nullable
    private final FetchProfileDebug debug;
    private final List<FetchProfile> children;
    public static final JsonpDeserializer<FetchProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FetchProfile::setupFetchProfileDeserializer);

    private FetchProfile(Builder builder) {
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.timeInNanos = ApiTypeHelper.requireNonNull(builder.timeInNanos, this, "timeInNanos");
        this.breakdown = ApiTypeHelper.requireNonNull(builder.breakdown, this, "breakdown");
        this.debug = builder.debug;
        this.children = ApiTypeHelper.unmodifiable(builder.children);
    }

    public static FetchProfile of(Function<Builder, ObjectBuilder<FetchProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String type() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final long timeInNanos() {
        return this.timeInNanos;
    }

    public final FetchProfileBreakdown breakdown() {
        return this.breakdown;
    }

    @Nullable
    public final FetchProfileDebug debug() {
        return this.debug;
    }

    public final List<FetchProfile> children() {
        return this.children;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
        generator.writeKey("breakdown");
        this.breakdown.serialize(generator, mapper);
        if (this.debug != null) {
            generator.writeKey("debug");
            this.debug.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (FetchProfile item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupFetchProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos");
        op.add(Builder::breakdown, FetchProfileBreakdown._DESERIALIZER, "breakdown");
        op.add(Builder::debug, FetchProfileDebug._DESERIALIZER, "debug");
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FetchProfile> {
        private String type;
        private String description;
        private Long timeInNanos;
        private FetchProfileBreakdown breakdown;
        @Nullable
        private FetchProfileDebug debug;
        @Nullable
        private List<FetchProfile> children;

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        public final Builder breakdown(FetchProfileBreakdown value) {
            this.breakdown = value;
            return this;
        }

        public final Builder breakdown(Function<FetchProfileBreakdown.Builder, ObjectBuilder<FetchProfileBreakdown>> fn) {
            return this.breakdown(fn.apply(new FetchProfileBreakdown.Builder()).build());
        }

        public final Builder debug(@Nullable FetchProfileDebug value) {
            this.debug = value;
            return this;
        }

        public final Builder debug(Function<FetchProfileDebug.Builder, ObjectBuilder<FetchProfileDebug>> fn) {
            return this.debug(fn.apply(new FetchProfileDebug.Builder()).build());
        }

        public final Builder children(List<FetchProfile> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        public final Builder children(FetchProfile value, FetchProfile ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        public final Builder children(Function<Builder, ObjectBuilder<FetchProfile>> fn) {
            return this.children(fn.apply(new Builder()).build(), new FetchProfile[0]);
        }

        @Override
        public FetchProfile build() {
            this._checkSingleUse();
            return new FetchProfile(this);
        }
    }
}

