/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.airlift.compress.zstd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.pulsar.shade.io.airlift.compress.hadoop.HadoopInputStream;
import org.apache.pulsar.shade.io.airlift.compress.zstd.ZstdInputStream;

class ZstdHadoopInputStream
extends HadoopInputStream {
    private final InputStream in;
    private ZstdInputStream zstdInputStream;

    public ZstdHadoopInputStream(InputStream in) {
        this.in = Objects.requireNonNull(in, "in is null");
        this.zstdInputStream = new ZstdInputStream(in);
    }

    @Override
    public int read() throws IOException {
        return this.zstdInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.zstdInputStream.read(b);
    }

    @Override
    public int read(byte[] outputBuffer, int outputOffset, int outputLength) throws IOException {
        return this.zstdInputStream.read(outputBuffer, outputOffset, outputLength);
    }

    @Override
    public void resetState() {
        this.zstdInputStream = new ZstdInputStream(this.in);
    }

    @Override
    public void close() throws IOException {
        this.zstdInputStream.close();
    }
}

