/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.services;

import jakarta.inject.Inject;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.task.Task;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.eventsourcing.TaskAggregateId;
import org.apache.james.task.eventsourcing.TaskExecutionDetailsProjection;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TasksCleanupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TasksCleanupService.class);
    private final TaskExecutionDetailsProjection taskExecutionDetailsProjection;
    private final EventStore eventStore;

    @Inject
    public TasksCleanupService(TaskExecutionDetailsProjection taskExecutionDetailsProjection, EventStore eventStore) {
        this.eventStore = eventStore;
        this.taskExecutionDetailsProjection = taskExecutionDetailsProjection;
    }

    public Mono<Task.Result> removeBeforeDate(Instant beforeDate, Context context) {
        return this.removeTask(beforeDate).doOnNext(pair -> TasksCleanupService.doOnNext((Pair<TaskId, Task.Result>)pair, context)).map(Pair::getValue).reduce((Object)Task.Result.COMPLETED, Task::combine).onErrorResume(e -> {
            LOGGER.error("Error listing tasks execution detail", e);
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }

    private Flux<Pair<TaskId, Task.Result>> removeTask(Instant beforeDate) {
        return Flux.from((Publisher)this.taskExecutionDetailsProjection.listDetailsByBeforeDate(beforeDate)).filter(oldTaskDetail -> !oldTaskDetail.getStatus().equals((Object)TaskManager.Status.WAITING) && !oldTaskDetail.getStatus().equals((Object)TaskManager.Status.IN_PROGRESS)).flatMap(oldTaskDetail -> Mono.from((Publisher)this.eventStore.remove((AggregateId)new TaskAggregateId(oldTaskDetail.getTaskId()))).then(Mono.from((Publisher)this.taskExecutionDetailsProjection.remove(oldTaskDetail))).then(Mono.just((Object)Pair.of((Object)oldTaskDetail.getTaskId(), (Object)Task.Result.COMPLETED))).onErrorResume(error -> {
            LOGGER.error("Error while cleanup task {}", (Object)oldTaskDetail.getTaskId().asString(), error);
            return Mono.just((Object)Pair.of((Object)oldTaskDetail.getTaskId(), (Object)Task.Result.PARTIAL));
        }));
    }

    private static void doOnNext(Pair<TaskId, Task.Result> next, Context context) {
        context.incrementProcessedTaskCount();
        if (Task.Result.COMPLETED.equals(next.getValue())) {
            context.incrementRemovedTasksCount();
        }
    }

    public static class Context {
        private final AtomicLong removedTasksCount = new AtomicLong();
        private final AtomicLong processedTaskCount = new AtomicLong();

        void incrementRemovedTasksCount() {
            this.removedTasksCount.incrementAndGet();
        }

        void incrementProcessedTaskCount() {
            this.processedTaskCount.incrementAndGet();
        }

        void incrementRemovedTasksCount(int count) {
            this.removedTasksCount.set(this.removedTasksCount.get() + (long)count);
        }

        public Snapshot snapshot() {
            return new Snapshot(this.removedTasksCount.get(), this.processedTaskCount.get());
        }

        public static class Snapshot {
            private final long removedTasksCount;
            private final long processedTaskCount;

            public Snapshot(long removedTasksCount, long processedTaskCount) {
                this.removedTasksCount = removedTasksCount;
                this.processedTaskCount = processedTaskCount;
            }

            public long getRemovedTasksCount() {
                return this.removedTasksCount;
            }

            public long getProcessedTaskCount() {
                return this.processedTaskCount;
            }
        }
    }
}

