/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.upload;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.cassandra.upload.UploadDataDefinition;
import org.apache.james.mailbox.model.ContentType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UploadDAO {
    public static final Instant UPLOAD_DATE_FALLBACK = Instant.EPOCH;
    private final CassandraAsyncExecutor executor;
    private final BlobId.Factory blobIdFactory;
    private final PreparedStatement insert;
    private final PreparedStatement selectOne;
    private final PreparedStatement delete;
    private final PreparedStatement list;
    private final PreparedStatement all;

    @Inject
    public UploadDAO(CqlSession session, BlobId.Factory blobIdFactory) {
        this.executor = new CassandraAsyncExecutor(session);
        this.blobIdFactory = blobIdFactory;
        this.insert = session.prepare(QueryBuilder.insertInto((String)"uploadsV2").value(UploadDataDefinition.ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadDataDefinition.ID)).value(UploadDataDefinition.BLOB_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadDataDefinition.BLOB_ID)).value(UploadDataDefinition.SIZE, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadDataDefinition.SIZE)).value(UploadDataDefinition.USER, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadDataDefinition.USER)).value(UploadDataDefinition.CONTENT_TYPE, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadDataDefinition.CONTENT_TYPE)).value(UploadDataDefinition.UPLOAD_DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadDataDefinition.UPLOAD_DATE)).build());
        this.list = session.prepare(((Select)QueryBuilder.selectFrom((String)"uploadsV2").all().whereColumn(UploadDataDefinition.USER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)UploadDataDefinition.USER))).build());
        this.selectOne = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"uploadsV2").all().whereColumn(UploadDataDefinition.USER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)UploadDataDefinition.USER))).whereColumn(UploadDataDefinition.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)UploadDataDefinition.ID))).build());
        this.delete = session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"uploadsV2").whereColumn(UploadDataDefinition.USER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)UploadDataDefinition.USER))).whereColumn(UploadDataDefinition.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)UploadDataDefinition.ID))).build());
        this.all = session.prepare(QueryBuilder.selectFrom((String)"uploadsV2").all().allowFiltering().build());
    }

    public Mono<Void> save(UploadRepresentation uploadRepresentation) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insert.bind(new Object[0]).setString(UploadDataDefinition.USER, uploadRepresentation.getUser().asString())).setUuid(UploadDataDefinition.ID, uploadRepresentation.getId().getId())).setString(UploadDataDefinition.BLOB_ID, uploadRepresentation.getBlobId().asString())).setLong(UploadDataDefinition.SIZE, uploadRepresentation.getSize())).setInstant(UploadDataDefinition.UPLOAD_DATE, uploadRepresentation.getUploadDate())).setString(UploadDataDefinition.CONTENT_TYPE, uploadRepresentation.getContentType().asString()));
    }

    public Mono<UploadRepresentation> retrieve(Username username, UploadId id) {
        return this.executor.executeSingleRow((Statement)((BoundStatement)this.selectOne.bind(new Object[0]).setString(UploadDataDefinition.USER, username.asString())).setUuid(UploadDataDefinition.ID, id.getId())).map(this.rowToUploadRepresentation());
    }

    public Flux<UploadRepresentation> list(Username username) {
        return Flux.from((Publisher)this.executor.executeRows((Statement)this.list.bind(new Object[0]).setString(UploadDataDefinition.USER, username.asString()))).map(this.rowToUploadRepresentation());
    }

    public Mono<Boolean> delete(Username username, UploadId uploadId) {
        return this.executor.executeVoid((Statement)((BoundStatement)this.delete.bind(new Object[0]).setString(UploadDataDefinition.USER, username.asString())).setUuid(UploadDataDefinition.ID, uploadId.getId())).thenReturn((Object)true);
    }

    public Flux<UploadRepresentation> all() {
        return Flux.from((Publisher)this.executor.executeRows((Statement)this.all.bind(new Object[0]))).map(this.rowToUploadRepresentation());
    }

    private Function<Row, UploadRepresentation> rowToUploadRepresentation() {
        return row -> new UploadRepresentation(UploadId.from((UUID)row.getUuid(UploadDataDefinition.ID)), this.blobIdFactory.parse(row.getString(UploadDataDefinition.BLOB_ID)), ContentType.of((String)row.getString(UploadDataDefinition.CONTENT_TYPE)), row.getLong(UploadDataDefinition.SIZE), Username.of((String)row.getString(UploadDataDefinition.USER)), Optional.ofNullable(row.getInstant(UploadDataDefinition.UPLOAD_DATE)).orElse(UPLOAD_DATE_FALLBACK));
    }

    public static class UploadRepresentation {
        private final UploadId id;
        private final BlobId blobId;
        private final ContentType contentType;
        private final long size;
        private final Username user;
        private final Instant uploadDate;

        public UploadRepresentation(UploadId id, BlobId blobId, ContentType contentType, long size, Username user, Instant uploadDate) {
            this.user = user;
            Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"Size must be strictly positive");
            this.id = id;
            this.blobId = blobId;
            this.contentType = contentType;
            this.size = size;
            this.uploadDate = uploadDate;
        }

        public UploadId getId() {
            return this.id;
        }

        public BlobId getBlobId() {
            return this.blobId;
        }

        public ContentType getContentType() {
            return this.contentType;
        }

        public long getSize() {
            return this.size;
        }

        public Username getUser() {
            return this.user;
        }

        public Instant getUploadDate() {
            return this.uploadDate;
        }

        public UploadMetaData toUploadMetaData() {
            return UploadMetaData.from((UploadId)this.id, (ContentType)this.contentType, (long)this.size, (BlobId)this.blobId, (Instant)this.uploadDate);
        }

        public boolean equals(Object obj) {
            if (obj instanceof UploadRepresentation) {
                UploadRepresentation other = (UploadRepresentation)obj;
                return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.user, (Object)other.user) && Objects.equal((Object)this.blobId, (Object)other.blobId) && Objects.equal((Object)this.contentType, (Object)other.contentType) && Objects.equal((Object)this.uploadDate, (Object)other.uploadDate) && Objects.equal((Object)this.size, (Object)other.size);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.blobId, this.contentType, this.size, this.user, this.uploadDate});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("blobId", (Object)this.blobId).add("contentType", (Object)this.contentType).add("user", (Object)this.user).add("user", (Object)this.user).add("uploadDate", (Object)this.uploadDate).toString();
        }
    }
}

