/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.ArrayCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.CodecMetadata;
import io.r2dbc.postgresql.codec.NumericDecodeUtils;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.Vector;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class VectorCodec
implements Codec<Vector>,
CodecMetadata,
ArrayCodecDelegate<Vector> {
    private final ByteBufAllocator byteBufAllocator;
    private final int oid;
    private final PostgresTypeIdentifier arrayOid;

    VectorCodec(ByteBufAllocator byteBufAllocator, int oid, int arrayOid) {
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.oid = oid;
        this.arrayOid = () -> arrayOid;
    }

    @Override
    public EncodedParameter encodeNull() {
        return new EncodedParameter(Format.FORMAT_BINARY, this.oid, (Publisher<? extends ByteBuf>)EncodedParameter.NULL_VALUE);
    }

    @Override
    public Class<?> type() {
        return Vector.class;
    }

    @Override
    public PostgresTypeIdentifier getArrayDataType() {
        return this.arrayOid;
    }

    @Override
    public Iterable<PostgresTypeIdentifier> getDataTypes() {
        return Collections.singleton(AbstractCodec.getDataType(this.oid));
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return dataType == this.oid && (type == Object.class || Vector.class.isAssignableFrom(type) || type.isAssignableFrom(float[].class) || type.isAssignableFrom(Float[].class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Vector;
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        return type == Object.class || Vector.class.isAssignableFrom(type) || type.isAssignableFrom(float[].class) || type.isAssignableFrom(Float[].class);
    }

    @Override
    public Vector decode(ByteBuf buffer, PostgresTypeIdentifier dataType, Format format, Class<? extends Vector> type) {
        return this.decode(buffer, dataType.getObjectId(), format, (Class)type);
    }

    @Override
    public Vector decode(@Nullable ByteBuf buffer, int dataType, Format format, Class<? extends Vector> type) {
        return buffer == null ? null : Vector.of(VectorCodec.decode(buffer, format));
    }

    static float[] decode(ByteBuf buffer, Format format) {
        if (format == Format.FORMAT_TEXT) {
            List<Number> objects = VectorCodec.decodeText(buffer, (byte)44);
            float[] values = new float[objects.size()];
            for (int i = 0; i < objects.size(); ++i) {
                Number v = objects.get(i);
                values[i] = v.floatValue();
            }
            return values;
        }
        int dim = buffer.readShort();
        buffer.readShort();
        float[] values = new float[dim];
        for (int i = 0; i < dim; ++i) {
            values[i] = buffer.readFloat();
        }
        return values;
    }

    @Override
    public EncodedParameter encode(Object value) {
        return this.encode(value, this.oid);
    }

    @Override
    public EncodedParameter encode(Object value, int dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return new EncodedParameter(Format.FORMAT_BINARY, dataType, (Publisher<? extends ByteBuf>)Mono.fromSupplier(() -> this.encodeBinary(((Vector)value).getVector())));
    }

    @Override
    public String encodeToText(Vector value) {
        return value.toString();
    }

    private ByteBuf allocateBuffer(int dim) {
        return this.byteBufAllocator.buffer(VectorCodec.estimateBufferSize(dim));
    }

    private ByteBuf encodeBinary(float[] values) {
        ByteBuf buffer = this.allocateBuffer(values.length);
        VectorCodec.encodeBinary(buffer, values);
        return buffer;
    }

    static void encodeBinary(ByteBuf buffer, float[] values) {
        VectorCodec.prepareBuffer(buffer, values.length);
        for (float v : values) {
            buffer.writeFloat(v);
        }
    }

    static int estimateBufferSize(int dim) {
        return 4 + 4 * dim;
    }

    private static void prepareBuffer(ByteBuf buffer, int dim) {
        buffer.writeShort(dim);
        buffer.writeShort(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Number> decodeText(ByteBuf buf, byte delimiter) {
        boolean insideString = false;
        boolean wasInsideString = false;
        ArrayList<Number> decoded = new ArrayList<Number>();
        int indentEscape = 0;
        int readFrom = 0;
        boolean requiresEscapeCharFiltering = false;
        while (buf.isReadable()) {
            byte currentChar = buf.readByte();
            if (currentChar == 92) {
                ++indentEscape;
                buf.skipBytes(1);
                requiresEscapeCharFiltering = true;
                continue;
            }
            if (!insideString && currentChar == 91) {
                for (int t = indentEscape + 1; t < buf.writerIndex() && (Character.isWhitespace(buf.getByte(t)) || buf.getByte(t) == 91); ++t) {
                }
                readFrom = buf.readerIndex();
                continue;
            }
            if (currentChar == 34) {
                insideString = !insideString;
                wasInsideString = true;
                continue;
            }
            if (!insideString && Character.isWhitespace(currentChar) || (insideString || currentChar != delimiter && currentChar != 93) && indentEscape != buf.writerIndex() - 1) continue;
            int skipTrailingBytes = 0;
            if (currentChar != 93 && currentChar != delimiter && readFrom > 0) {
                ++skipTrailingBytes;
            }
            if (wasInsideString) {
                ++readFrom;
                ++skipTrailingBytes;
            }
            ByteBuf slice = buf.slice(readFrom, buf.readerIndex() - readFrom - (skipTrailingBytes + 1));
            try {
                if (requiresEscapeCharFiltering) {
                    ByteBuf filtered = slice.alloc().buffer(slice.readableBytes());
                    while (slice.isReadable()) {
                        byte ch = slice.readByte();
                        if (ch == 92) {
                            ch = slice.readByte();
                        }
                        filtered.writeByte((int)ch);
                    }
                    slice = filtered;
                }
                if (slice.isReadable() || wasInsideString) {
                    if (!wasInsideString && slice.readableBytes() == 4 && slice.getByte(0) == 78 && "NULL".equals(slice.toString(StandardCharsets.US_ASCII))) {
                        decoded.add(null);
                    } else {
                        decoded.add(NumericDecodeUtils.decodeNumber(slice, PostgresqlObjectId.FLOAT4, Format.FORMAT_TEXT));
                    }
                }
            }
            finally {
                if (requiresEscapeCharFiltering) {
                    slice.release();
                }
            }
            wasInsideString = false;
            requiresEscapeCharFiltering = false;
            readFrom = buf.readerIndex();
        }
        return decoded;
    }

    static class VectorArrayCodec
    extends ArrayCodec<Vector> {
        private final ByteBufAllocator byteBufAllocator;

        public VectorArrayCodec(ByteBufAllocator byteBufAllocator, VectorCodec delegate) {
            super(byteBufAllocator, delegate, Vector.class);
            this.byteBufAllocator = byteBufAllocator;
        }

        public VectorCodec getDelegate() {
            return (VectorCodec)super.getDelegate();
        }

        @Override
        EncodedParameter doEncode(Object[] value, PostgresTypeIdentifier dataType) {
            boolean hasNulls = VectorArrayCodec.hasNulls(value);
            return new EncodedParameter(Format.FORMAT_BINARY, dataType.getObjectId(), (Publisher<? extends ByteBuf>)Mono.fromSupplier(() -> {
                ByteBuf buffer = this.byteBufAllocator.buffer();
                buffer.writeInt(1);
                buffer.writeInt(hasNulls ? 1 : 0);
                buffer.writeInt(this.getDelegate().getArrayDataType().getObjectId());
                buffer.writeInt(value.length);
                buffer.writeInt(0);
                for (Object o : value) {
                    if (o == null) {
                        buffer.writeInt(-1);
                        continue;
                    }
                    ByteBuf nested = this.byteBufAllocator.buffer();
                    VectorCodec.encodeBinary(nested, ((Vector)o).getVector());
                    buffer.writeInt(nested.readableBytes());
                    buffer.writeBytes(nested);
                    nested.release();
                }
                return buffer;
            }));
        }

        private static boolean hasNulls(Object[] value) {
            for (Object o : value) {
                if (o != null) continue;
                return true;
            }
            return false;
        }
    }
}

