/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.sieve.cassandra.CassandraSieveQuotaDAO;
import org.apache.james.sieve.cassandra.tables.CassandraSieveClusterQuotaTable;
import org.apache.james.sieve.cassandra.tables.CassandraSieveQuotaTable;
import org.apache.james.sieve.cassandra.tables.CassandraSieveSpaceTable;
import reactor.core.publisher.Mono;

@Deprecated
public class CassandraSieveQuotaDAOV1
implements CassandraSieveQuotaDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement selectClusterQuotaStatement;
    private final PreparedStatement selectSpaceUsedByUserStatement;
    private final PreparedStatement selectUserQuotaStatement;
    private final PreparedStatement updateClusterQuotaStatement;
    private final PreparedStatement updateUserQuotaStatement;
    private final PreparedStatement updateSpaceUsedStatement;
    private final PreparedStatement deleteClusterQuotaStatement;
    private final PreparedStatement deleteUserQuotaStatement;

    @Inject
    public CassandraSieveQuotaDAOV1(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.selectClusterQuotaStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"sieve_cluster_quota").column(CassandraSieveClusterQuotaTable.VALUE).whereColumn(CassandraSieveClusterQuotaTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveClusterQuotaTable.NAME))).build());
        this.selectSpaceUsedByUserStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"sieve_space").column(CassandraSieveSpaceTable.SPACE_USED).whereColumn(CassandraSieveSpaceTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveSpaceTable.USER_NAME))).build());
        this.selectUserQuotaStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"sieve_quota").column(CassandraSieveQuotaTable.QUOTA).whereColumn(CassandraSieveQuotaTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveQuotaTable.USER_NAME))).build());
        this.updateClusterQuotaStatement = session.prepare(((Update)QueryBuilder.update((String)"sieve_cluster_quota").setColumn(CassandraSieveClusterQuotaTable.VALUE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveClusterQuotaTable.VALUE)).whereColumn(CassandraSieveClusterQuotaTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveClusterQuotaTable.NAME))).build());
        this.updateSpaceUsedStatement = session.prepare(((Update)QueryBuilder.update((String)"sieve_space").increment(CassandraSieveSpaceTable.SPACE_USED, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveSpaceTable.SPACE_USED)).whereColumn(CassandraSieveSpaceTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveSpaceTable.USER_NAME))).build());
        this.updateUserQuotaStatement = session.prepare(((Update)QueryBuilder.update((String)"sieve_quota").setColumn(CassandraSieveQuotaTable.QUOTA, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveQuotaTable.QUOTA)).whereColumn(CassandraSieveQuotaTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveQuotaTable.USER_NAME))).build());
        this.deleteClusterQuotaStatement = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"sieve_cluster_quota").whereColumn(CassandraSieveClusterQuotaTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveClusterQuotaTable.NAME))).build());
        this.deleteUserQuotaStatement = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"sieve_quota").whereColumn(CassandraSieveQuotaTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveQuotaTable.USER_NAME))).build());
    }

    @Override
    public Mono<Long> spaceUsedBy(Username username) {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)this.selectSpaceUsedByUserStatement.bind(new Object[0]).setString(CassandraSieveSpaceTable.USER_NAME, username.asString())).map(optional -> optional.map(row -> row.getLong(CassandraSieveSpaceTable.SPACE_USED)).orElse(0L));
    }

    @Override
    public Mono<Void> updateSpaceUsed(Username username, long spaceUsed) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.updateSpaceUsedStatement.bind(new Object[0]).setLong(CassandraSieveSpaceTable.SPACE_USED, spaceUsed)).setString(CassandraSieveSpaceTable.USER_NAME, username.asString()));
    }

    @Override
    public Mono<Optional<QuotaSizeLimit>> getQuota() {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)this.selectClusterQuotaStatement.bind(new Object[0]).setString(CassandraSieveClusterQuotaTable.NAME, "cluster_quota")).map(optional -> optional.map(row -> QuotaSizeLimit.size((long)row.getLong(CassandraSieveClusterQuotaTable.VALUE))));
    }

    @Override
    public Mono<Void> setQuota(QuotaSizeLimit quota) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.updateClusterQuotaStatement.bind(new Object[0]).setLong(CassandraSieveClusterQuotaTable.VALUE, quota.asLong())).setString(CassandraSieveClusterQuotaTable.NAME, "cluster_quota"));
    }

    @Override
    public Mono<Void> removeQuota() {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteClusterQuotaStatement.bind(new Object[0]).setString(CassandraSieveClusterQuotaTable.NAME, "cluster_quota"));
    }

    @Override
    public Mono<Optional<QuotaSizeLimit>> getQuota(Username username) {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)this.selectUserQuotaStatement.bind(new Object[0]).setString(CassandraSieveQuotaTable.USER_NAME, username.asString())).map(optional -> optional.map(row -> QuotaSizeLimit.size((long)row.getLong(CassandraSieveQuotaTable.QUOTA))));
    }

    @Override
    public Mono<Void> setQuota(Username username, QuotaSizeLimit quota) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.updateUserQuotaStatement.bind(new Object[0]).setLong(CassandraSieveQuotaTable.QUOTA, quota.asLong())).setString(CassandraSieveQuotaTable.USER_NAME, username.asString()));
    }

    @Override
    public Mono<Void> removeQuota(Username username) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteUserQuotaStatement.bind(new Object[0]).setString(CassandraSieveQuotaTable.USER_NAME, username.asString()));
    }

    @Override
    public Mono<Void> resetSpaceUsed(Username username, long spaceUsed) {
        return this.spaceUsedBy(username).flatMap(currentSpace -> this.updateSpaceUsed(username, spaceUsed - currentSpace));
    }
}

