/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.postgres.extensions.types;

import java.util.Objects;
import org.jooq.exception.DataTypeException;
import org.jooq.postgres.extensions.types.AbstractRange;

abstract class AbstractDiscreteRange<T, R extends AbstractDiscreteRange<T, R>>
extends AbstractRange<T> {
    AbstractDiscreteRange(T lower, boolean lowerIncluding, T upper, boolean upperIncluding) {
        super(lower, lowerIncluding, upper, upperIncluding);
    }

    abstract T next(T var1) throws DataTypeException;

    abstract T prev(T var1) throws DataTypeException;

    abstract R construct(T var1, T var2);

    final boolean isCanonical() {
        return !(this.lower() != null && !this.lowerIncluding() || this.upper() != null && this.upperIncluding());
    }

    final R canonical() {
        if (this.isCanonical()) {
            return (R)this;
        }
        Object l = this.lower();
        Object u = this.upper();
        if (!this.lowerIncluding() && l != null) {
            l = this.next(l);
        }
        if (this.upperIncluding() && u != null) {
            u = this.next(u);
        }
        return this.construct(l, u);
    }

    @Override
    public boolean isEmpty() {
        if (this.isCanonical()) {
            return super.isEmpty();
        }
        return ((AbstractDiscreteRange)this.canonical()).isEmpty();
    }

    @Override
    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.isCanonical()) {
            return Objects.hash(this.lower(), this.upper());
        }
        return ((AbstractDiscreteRange)this.canonical()).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        AbstractDiscreteRange<T, R> r2;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDiscreteRange other = (AbstractDiscreteRange)obj;
        boolean c1 = this.isCanonical();
        boolean c2 = other.isCanonical();
        AbstractDiscreteRange<T, R> r1 = c1 ? this : this.canonical();
        AbstractDiscreteRange<T, R> abstractDiscreteRange = r2 = c2 ? other : other.canonical();
        if (r1.isEmpty()) {
            return r2.isEmpty();
        }
        return Objects.equals(r1.lower(), r2.lower()) && Objects.equals(r1.upper(), r2.upper());
    }
}

