/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.Transform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0019\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\tJ \u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\nH\u0016J\u001c\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\n2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\nH\u0004R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/FunTransform;", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "transformFun", "Lkotlin/Function1;", "", "inverseFun", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "apply", "v", "(Ljava/lang/Double;)Ljava/lang/Double;", "", "l", "applyInverse", "safeCastToDoubles", "list", "plot-base"})
@SourceDebugExtension(value={"SMAP\nFunTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunTransform.kt\norg/jetbrains/letsPlot/core/plot/base/scale/transform/FunTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1549#2:46\n1620#2,3:47\n1549#2:50\n1620#2,3:51\n1#3:54\n*S KotlinDebug\n*F\n+ 1 FunTransform.kt\norg/jetbrains/letsPlot/core/plot/base/scale/transform/FunTransform\n*L\n24#1:46\n24#1:47,3\n36#1:50\n36#1:51,3\n*E\n"})
public abstract class FunTransform
implements ContinuousTransform {
    @NotNull
    private final Function1<Double, Double> transformFun;
    @NotNull
    private final Function1<Double, Double> inverseFun;

    public FunTransform(@NotNull Function1<? super Double, Double> transformFun, @NotNull Function1<? super Double, Double> inverseFun) {
        Intrinsics.checkNotNullParameter(transformFun, (String)"transformFun");
        Intrinsics.checkNotNullParameter(inverseFun, (String)"inverseFun");
        this.transformFun = transformFun;
        this.inverseFun = inverseFun;
    }

    @Override
    @Nullable
    public Double apply(@Nullable Double v) {
        return v != null ? (Double)this.transformFun.invoke((Object)v) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Double> apply(@NotNull List<?> l) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Iterable $this$map$iv = this.safeCastToDoubles(l);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Double d = (Double)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.apply((Double)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Double applyInverse(@Nullable Double v) {
        return v != null ? (Double)this.inverseFun.invoke((Object)v) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Double> applyInverse(@NotNull List<Double> l) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Iterable $this$map$iv = l;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Double d = (Double)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.applyInverse((Double)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final List<Double> safeCastToDoubles(@NotNull List<?> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        SeriesUtil.CheckedDoubleList checkedDoubles = SeriesUtil.INSTANCE.checkedDoubles(list2);
        if (!checkedDoubles.canBeCast()) {
            boolean bl = false;
            String string = "Not a collections of Double(s)";
            throw new IllegalStateException(string.toString());
        }
        return checkedDoubles.cast();
    }

    @Override
    public boolean isInDomain(@Nullable Object v) {
        return ContinuousTransform.DefaultImpls.isInDomain(this, v);
    }

    @Override
    @NotNull
    public Pair<Double, Double> definedLimits() {
        return ContinuousTransform.DefaultImpls.definedLimits(this);
    }

    @Override
    @NotNull
    public Transform unwrap() {
        return ContinuousTransform.DefaultImpls.unwrap(this);
    }
}

