/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.async.ConnectionContext;

public class ImmutableConnectionContext
implements ConnectionContext {
    private static final ConnectionContext SINGLE_DB_CONTEXT = new ImmutableConnectionContext(DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), AccessMode.READ);
    private static final ConnectionContext MULTI_DB_CONTEXT = new ImmutableConnectionContext(DatabaseNameUtil.systemDatabase(), InternalBookmark.empty(), AccessMode.READ);
    private final CompletableFuture<DatabaseName> databaseNameFuture;
    private final AccessMode mode;
    private final Bookmark rediscoveryBookmark;

    public ImmutableConnectionContext(DatabaseName databaseName, Bookmark bookmark, AccessMode mode) {
        this.databaseNameFuture = CompletableFuture.completedFuture(databaseName);
        this.rediscoveryBookmark = bookmark;
        this.mode = mode;
    }

    @Override
    public CompletableFuture<DatabaseName> databaseNameFuture() {
        return this.databaseNameFuture;
    }

    @Override
    public AccessMode mode() {
        return this.mode;
    }

    @Override
    public Bookmark rediscoveryBookmark() {
        return this.rediscoveryBookmark;
    }

    @Override
    public String impersonatedUser() {
        return null;
    }

    public static ConnectionContext simple(boolean supportsMultiDb) {
        return supportsMultiDb ? MULTI_DB_CONTEXT : SINGLE_DB_CONTEXT;
    }
}

