/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import io.micrometer.context.ContextSnapshot;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.observability.SignalListener;
import org.neo4j.driver.internal.shaded.reactor.core.observability.SignalListenerFactory;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.ContextPropagation;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxTapRestoringThreadLocals;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InternalProducerAttr;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.MonoOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.neo4j.driver.internal.shaded.reactor.util.context.Context;

final class MonoTapRestoringThreadLocals<T, STATE>
extends MonoOperator<T, T> {
    final SignalListenerFactory<T, STATE> tapFactory;
    final STATE commonTapState;

    MonoTapRestoringThreadLocals(Mono<? extends T> source, SignalListenerFactory<T, STATE> tapFactory) {
        super(source);
        this.tapFactory = tapFactory;
        this.commonTapState = tapFactory.initializePublisherState(source);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Context alteredContext;
        SignalListener<T> signalListener;
        try {
            signalListener = this.tapFactory.createListener(this.source, actual.currentContext().readOnly(), this.commonTapState);
        }
        catch (Throwable generatorError) {
            Operators.error(actual, generatorError);
            return;
        }
        try {
            signalListener.doFirst();
        }
        catch (Throwable listenerError) {
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return;
        }
        try {
            alteredContext = signalListener.addToContext(actual.currentContext());
        }
        catch (Throwable e) {
            signalListener.handleListenerError(new IllegalStateException("Unable to augment tap Context at construction via addToContext", e));
            alteredContext = actual.currentContext();
        }
        try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(alteredContext);){
            this.source.subscribe(new FluxTapRestoringThreadLocals.TapSubscriber<T>(actual, signalListener, alteredContext));
        }
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return -1;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return super.scanUnsafe(key);
    }
}

