/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.email;

import com.helger.commons.name.IHasDisplayName;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IEmailAddress
extends IHasDisplayName {
    @Nonnull
    public String getAddress();

    @Nullable
    public String getPersonal();

    default public boolean hasPersonal() {
        return StringHelper.hasText(this.getPersonal());
    }

    @Override
    @Nonnull
    default public String getDisplayName() {
        if (this.hasPersonal()) {
            return this.getPersonal() + " <" + this.getAddress() + ">";
        }
        return this.getAddress();
    }
}

