/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.id.factory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.factory.AbstractPersistingIntIDFactory;
import com.helger.commons.io.file.EFileIOErrorCode;
import com.helger.commons.io.file.EFileIOOperation;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FileIntIDFactory
extends AbstractPersistingIntIDFactory {
    public static final Charset CHARSET_TO_USE = StandardCharsets.ISO_8859_1;
    public static final int DEFAULT_RESERVE_COUNT = 20;
    private final File m_aFile;
    private final File m_aPrevFile;
    private final File m_aNewFile;

    public FileIntIDFactory(@Nonnull File file) {
        this(file, 20);
    }

    public FileIntIDFactory(@Nonnull File file, @Nonnegative int n) {
        super(n);
        ValueEnforcer.notNull(file, "File");
        this.m_aFile = file;
        this.m_aPrevFile = new File(file.getParentFile(), file.getName() + ".prev");
        this.m_aNewFile = new File(file.getParentFile(), file.getName() + ".new");
        if (!FileHelper.canReadAndWriteFile(this.m_aFile)) {
            throw new IllegalArgumentException("Cannot read and/or write the file " + this.m_aFile + "!");
        }
        if (!FileHelper.canReadAndWriteFile(this.m_aPrevFile)) {
            throw new IllegalArgumentException("Cannot read and/or write the file " + this.m_aPrevFile + "!");
        }
        if (!FileHelper.canReadAndWriteFile(this.m_aNewFile)) {
            throw new IllegalArgumentException("Cannot read and/or write the file " + this.m_aNewFile + "!");
        }
        if (this.m_aNewFile.exists()) {
            throw new IllegalStateException("The temporary ID file '" + this.m_aNewFile.getAbsolutePath() + "' already exists! Please use the file with the highest number. Please resolve this conflict manually.");
        }
        if (this.m_aPrevFile.exists()) {
            throw new IllegalStateException("The temporary ID file '" + this.m_aPrevFile.getAbsolutePath() + "' already exists! If the ID file '" + this.m_aFile.getAbsolutePath() + "' exists and contains a higher number, you may consider deleting this file. Please resolve this conflict manually.");
        }
    }

    @Nonnull
    public final File getFile() {
        return this.m_aFile;
    }

    @Override
    @MustBeLocked(value=ELockType.WRITE)
    protected final int readAndUpdateIDCounter(@Nonnegative int n) {
        FileIOError fileIOError;
        String string = SimpleFileIO.getFileAsString(this.m_aFile, CHARSET_TO_USE);
        int n2 = string != null ? StringParser.parseInt(string.trim(), 0) : 0;
        SimpleFileIO.writeFile(this.m_aNewFile, Integer.toString(n2 + n), CHARSET_TO_USE);
        boolean bl = false;
        if (this.m_aFile.exists()) {
            fileIOError = FileOperationManager.INSTANCE.renameFile(this.m_aFile, this.m_aPrevFile);
            bl = true;
        } else {
            fileIOError = new FileIOError(EFileIOOperation.RENAME_FILE, EFileIOErrorCode.NO_ERROR);
        }
        if (fileIOError.isSuccess()) {
            fileIOError = FileOperationManager.INSTANCE.renameFile(this.m_aNewFile, this.m_aFile);
            if (fileIOError.isSuccess()) {
                fileIOError = FileOperationManager.INSTANCE.deleteFileIfExisting(this.m_aPrevFile);
            } else if (bl) {
                FileOperationManager.INSTANCE.renameFile(this.m_aPrevFile, this.m_aFile);
            }
        }
        if (fileIOError.isFailure()) {
            throw new IllegalStateException("Error on rename(existing-old)/rename(new-existing)/delete(old): " + fileIOError);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FileIntIDFactory fileIntIDFactory = (FileIntIDFactory)object;
        return this.m_aFile.equals(fileIntIDFactory.m_aFile);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFile).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("file", this.m_aFile).getToString();
    }
}

