/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Function.class})
public class ChangeCase
extends AbstractFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeCase.class);
    private static final List<String> DESC = new ArrayList<String>();
    private static final String KEY = "__changeCase";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 3;
    private CompoundVariable[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String originalString = this.values[0].execute();
        String mode = null;
        if (this.values.length > 1) {
            mode = this.values[1].execute();
        }
        if (StringUtils.isEmpty(mode)) {
            mode = ChangeCaseMode.UPPER.getName();
        }
        String targetString = this.changeCase(originalString, mode);
        this.addVariableValue(targetString, this.values, 2);
        return targetString;
    }

    protected String changeCase(String originalString, String mode) {
        String targetString = originalString;
        ChangeCaseMode changeCaseMode = ChangeCaseMode.typeOf(mode.toUpperCase(Locale.ROOT));
        if (changeCaseMode != null) {
            switch (changeCaseMode) {
                case UPPER: {
                    targetString = StringUtils.upperCase((String)originalString);
                    break;
                }
                case LOWER: {
                    targetString = StringUtils.lowerCase((String)originalString);
                    break;
                }
                case CAPITALIZE: {
                    targetString = StringUtils.capitalize((String)originalString);
                }
            }
        } else {
            LOGGER.error("Unknown mode {}, returning {} unchanged", (Object)mode, (Object)targetString);
        }
        return targetString;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 3);
        this.values = parameters.toArray(new CompoundVariable[parameters.size()]);
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return DESC;
    }

    static {
        DESC.add(JMeterUtils.getResString((String)"change_case_string"));
        DESC.add(JMeterUtils.getResString((String)"change_case_mode"));
        DESC.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }

    public static enum ChangeCaseMode {
        UPPER("UPPER"),
        LOWER("LOWER"),
        CAPITALIZE("CAPITALIZE");

        private final String mode;

        private ChangeCaseMode(String mode) {
            this.mode = mode;
        }

        public String getName() {
            return this.mode;
        }

        public static ChangeCaseMode typeOf(String mode) {
            EnumSet<ChangeCaseMode> allOf = EnumSet.allOf(ChangeCaseMode.class);
            for (ChangeCaseMode csm : allOf) {
                if (!csm.getName().equals(mode)) continue;
                return csm;
            }
            return null;
        }
    }
}

