/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.Stack;
import net.sf.saxon.expr.sort.EmptyIntIterator;
import net.sf.saxon.regex.OpCapture;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.charclass.CharacterClass;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSingletonIterator;

public class OpRepeat
extends Operation {
    protected Operation op;
    protected int min;
    protected int max;
    boolean greedy;

    OpRepeat(Operation op, int min, int max, boolean greedy) {
        this.op = op;
        this.min = min;
        this.max = max;
        this.greedy = greedy;
    }

    Operation getRepeatedOperation() {
        return this.op;
    }

    @Override
    public int matchesEmptyString() {
        if (this.min == 0) {
            return 7;
        }
        return this.op.matchesEmptyString();
    }

    @Override
    public boolean containsCapturingExpressions() {
        return this.op instanceof OpCapture || this.op.containsCapturingExpressions();
    }

    @Override
    public CharacterClass getInitialCharacterClass(boolean caseBlind) {
        return this.op.getInitialCharacterClass(caseBlind);
    }

    @Override
    public int getMatchLength() {
        return this.min == this.max && this.op.getMatchLength() >= 0 ? this.min * this.op.getMatchLength() : -1;
    }

    @Override
    public int getMinimumMatchLength() {
        return this.min * this.op.getMinimumMatchLength();
    }

    @Override
    public Operation optimize(REProgram program, REFlags flags) {
        this.op = this.op.optimize(program, flags);
        if (this.min == 0 && this.op.matchesEmptyString() == 7) {
            this.min = 1;
        }
        return this;
    }

    @Override
    public IntIterator iterateMatches(final REMatcher matcher, final int position) {
        final Stack<IntIterator> iterators = new Stack<IntIterator>();
        final Stack<Integer> positions = new Stack<Integer>();
        final int bound = Math.min(this.max, matcher.search.length32() - position + 1);
        int p = position;
        if (this.greedy) {
            if (this.min == 0 && !matcher.history.isDuplicateZeroLengthMatch(this, position)) {
                iterators.push(new IntSingletonIterator(position));
                positions.push(p);
            }
            for (int i = 0; i < bound; ++i) {
                IntIterator it = this.op.iterateMatches(matcher, p);
                if (!it.hasNext()) {
                    if (!iterators.isEmpty()) break;
                    return EmptyIntIterator.getInstance();
                }
                p = it.next();
                iterators.push(it);
                positions.push(p);
            }
            IntIterator base = new IntIterator(){
                boolean primed = true;

                private void advance() {
                    IntIterator top = (IntIterator)iterators.peek();
                    if (top.hasNext()) {
                        IntIterator it;
                        int p = top.next();
                        positions.pop();
                        positions.push(p);
                        while (iterators.size() < bound && (it = OpRepeat.this.op.iterateMatches(matcher, p)).hasNext()) {
                            p = it.next();
                            iterators.push(it);
                            positions.push(p);
                        }
                    } else {
                        iterators.pop();
                        positions.pop();
                    }
                }

                @Override
                public boolean hasNext() {
                    if (this.primed && iterators.size() >= OpRepeat.this.min) {
                        return !iterators.isEmpty();
                    }
                    if (iterators.isEmpty()) {
                        return false;
                    }
                    do {
                        this.advance();
                    } while (iterators.size() < OpRepeat.this.min && !iterators.isEmpty());
                    return !iterators.isEmpty();
                }

                @Override
                public int next() {
                    this.primed = false;
                    return (Integer)positions.peek();
                }
            };
            return new Operation.ForceProgressIterator(base);
        }
        IntIterator iter = new IntIterator(){
            private int pos;
            private int counter;
            {
                this.pos = position;
                this.counter = 0;
            }

            private void advance() {
                IntIterator it = OpRepeat.this.op.iterateMatches(matcher, this.pos);
                if (it.hasNext()) {
                    this.pos = it.next();
                    if (++this.counter > OpRepeat.this.max) {
                        this.pos = -1;
                    }
                } else if (OpRepeat.this.min == 0 && this.counter == 0) {
                    ++this.counter;
                } else {
                    this.pos = -1;
                }
            }

            @Override
            public boolean hasNext() {
                do {
                    this.advance();
                } while (this.counter < OpRepeat.this.min && this.pos >= 0);
                return this.pos >= 0;
            }

            @Override
            public int next() {
                return this.pos;
            }
        };
        return new Operation.ForceProgressIterator(iter);
    }

    @Override
    public String display() {
        String quantifier = this.min == 0 && this.max == Integer.MAX_VALUE ? "*" : (this.min == 1 && this.max == Integer.MAX_VALUE ? "+" : (this.min == 0 && this.max == 1 ? "?" : "{" + this.min + "," + this.max + "}"));
        if (!this.greedy) {
            quantifier = quantifier + "?";
        }
        return this.op.display() + quantifier;
    }
}

