/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.spinner;

import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.spinner.SpinnerConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;

public class DarkSpinnerLayout
implements LayoutManager {
    private final Insets editorInsets = UIManager.getInsets("Spinner.editorInsets");
    private final Insets editorCellInsets = UIManager.getInsets("Spinner.cellEditorInsets");
    private final Insets arrowButtonInsets = UIManager.getInsets("Spinner.arrowButtonInsets");
    private Component nextButton = null;
    private Component previousButton = null;
    private Component editor = null;

    @Override
    public void addLayoutComponent(String name, Component c) {
        if ("Next".equals(name)) {
            this.nextButton = c;
        } else if ("Previous".equals(name)) {
            this.previousButton = c;
        } else if ("Editor".equals(name)) {
            this.editor = c;
        }
    }

    @Override
    public void removeLayoutComponent(Component c) {
        if (c == this.nextButton) {
            this.nextButton = null;
        } else if (c == this.previousButton) {
            this.previousButton = null;
        } else if (c == this.editor) {
            this.editor = null;
        }
    }

    private Dimension preferredSize(Component c) {
        return c == null ? new Dimension() : c.getPreferredSize();
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension nextD = this.preferredSize(this.nextButton);
        Dimension previousD = this.preferredSize(this.previousButton);
        Dimension editorD = this.preferredSize(this.editor);
        editorD.height = (editorD.height + 1) / 2 * 2;
        Insets editorIns = this.getEditorInsets(parent);
        Insets buttonIns = this.arrowButtonInsets;
        Dimension size = new Dimension(editorD.width, editorD.height);
        size.width += Math.max(nextD.width, previousD.width);
        Insets insets = parent.getInsets();
        size.width += insets.left + insets.right + editorIns.left + editorIns.right + buttonIns.left + buttonIns.right;
        size.height += insets.top + insets.bottom + Math.max(editorIns.top, buttonIns.top) + Math.max(editorIns.bottom, buttonIns.bottom);
        return size;
    }

    protected Insets getEditorInsets(Container c) {
        if (SpinnerConstants.isTreeOrTableCellEditor(c)) {
            return CellUtil.adjustEditorInsets(new InsetsUIResource(this.editorCellInsets.top, this.editorCellInsets.left, this.editorCellInsets.bottom, this.editorCellInsets.right), c);
        }
        return this.editorInsets;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    private void setBounds(Component c, int x, int y, int width, int height) {
        if (c != null) {
            c.setBounds(x, y, width, height);
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        int buttonsX;
        int width = parent.getWidth();
        int height = parent.getHeight();
        Insets insets = parent.getInsets();
        Insets editorIns = this.getEditorInsets(parent);
        int editorX = insets.left + editorIns.left;
        int editorY = insets.top + editorIns.top;
        int editorWidth = width - editorX - insets.right - editorIns.right;
        int editorHeight = height - editorY - insets.bottom - editorIns.bottom;
        if (this.nextButton == null && this.previousButton == null) {
            this.setBounds(this.editor, editorX, editorY, editorWidth, editorHeight);
            return;
        }
        Dimension nextD = this.preferredSize(this.nextButton);
        Dimension previousD = this.preferredSize(this.previousButton);
        int buttonsWidth = Math.max(nextD.width, previousD.width);
        Insets buttonInsets = this.arrowButtonInsets;
        int fullButtonWidth = buttonsWidth + buttonInsets.left + buttonInsets.right;
        editorWidth -= fullButtonWidth;
        if (parent.getComponentOrientation().isLeftToRight()) {
            buttonsX = width - insets.right - fullButtonWidth;
        } else {
            buttonsX = insets.left;
            editorX = width - insets.right - editorIns.right - editorWidth;
        }
        int nextY = insets.top + buttonInsets.top;
        int nextHeight = height / 2 + height % 2 - nextY;
        int previousY = nextY + nextHeight;
        int previousHeight = height - insets.bottom - buttonInsets.bottom - previousY;
        this.setBounds(this.editor, editorX, editorY, editorWidth, editorHeight);
        this.setBounds(this.nextButton, buttonsX, nextY, fullButtonWidth, nextHeight);
        this.setBounds(this.previousButton, buttonsX, previousY, fullButtonWidth, previousHeight);
    }
}

